"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCurrentPlanStyles = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCurrentPlanStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _react.useMemo)(() => {
    return {
      currentPlanWrapperStyles: (0, _css.css)({
        backgroundColor: euiTheme.colors.lightestShade,
        borderRadius: '56px',
        padding: `${euiTheme.size.xs} ${euiTheme.size.s} ${euiTheme.size.xs} ${euiTheme.size.m}`,
        height: euiTheme.size.xl
      }),
      currentPlanTextStyles: (0, _css.css)({
        fontSize: euiTheme.size.m,
        fontWeight: euiTheme.font.weight.bold,
        paddingRight: euiTheme.size.xs
      }),
      projectFeaturesUrlStyles: (0, _css.css)({
        marginLeft: euiTheme.size.xs
      })
    };
  }, [euiTheme.colors.lightestShade, euiTheme.font.weight.bold, euiTheme.size.m, euiTheme.size.s, euiTheme.size.xl, euiTheme.size.xs]);
  return styles;
};
exports.useCurrentPlanStyles = useCurrentPlanStyles;