"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCardStepStyles = exports.HEIGHT_ANIMATION_DURATION = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HEIGHT_ANIMATION_DURATION = exports.HEIGHT_ANIMATION_DURATION = 250;
const useCardStepStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const completeStepBackgroundColor = (0, _eui.useEuiBackgroundColor)('success');
  const customStyles = (0, _react.useMemo)(() => ({
    stepPanelStyles: (0, _css.css)({
      '.stepContentWrapper': {
        display: 'grid',
        gridTemplateRows: '1fr',
        transition: `grid-template-rows ${HEIGHT_ANIMATION_DURATION}ms ease-in`
      },
      '&.step-panel-collapsed .stepContentWrapper': {
        gridTemplateRows: '0fr'
      },
      '.stepContent': {
        overflow: 'hidden'
      }
    }),
    getStepGroundStyles: ({
      hasStepContent
    }) => (0, _css.css)({
      cursor: hasStepContent ? 'pointer' : 'default',
      gap: euiTheme.size.base
    }),
    stepItemStyles: (0, _css.css)({
      alignSelf: 'center'
    }),
    stepIconStyles: (0, _css.css)({
      '&.step-icon': {
        borderRadius: '50%',
        width: euiTheme.size.xxxl,
        height: euiTheme.size.xxxl,
        padding: euiTheme.size.m,
        backgroundColor: euiTheme.colors.body
      },
      '&.step-icon-done': {
        backgroundColor: completeStepBackgroundColor
      }
    }),
    stepTitleStyles: (0, _css.css)({
      '&.step-title': {
        paddingRight: euiTheme.size.m,
        lineHeight: euiTheme.size.xxxl,
        fontSize: `${euiTheme.base * 0.875}px`,
        fontWeight: euiTheme.font.weight.semiBold,
        verticalAlign: 'middle'
      }
    }),
    allDoneTextStyles: (0, _css.css)({
      '&.all-done-badge': {
        backgroundColor: completeStepBackgroundColor,
        color: euiTheme.colors.successText
      }
    }),
    toggleButtonStyles: (0, _css.css)({
      '&.toggle-button': {
        marginLeft: `${euiTheme.base * 0.375}px`
      }
    })
  }), [completeStepBackgroundColor, euiTheme.base, euiTheme.colors.body, euiTheme.colors.successText, euiTheme.font.weight.semiBold, euiTheme.size.base, euiTheme.size.m, euiTheme.size.xxxl]);
  return customStyles;
};
exports.useCardStepStyles = useCardStepStyles;