"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddIntegrationsCalloutStyles = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAddIntegrationsCalloutStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const backgroundColor = (0, _eui.useEuiBackgroundColor)('primary');
  const customStyles = (0, _react.useMemo)(() => ({
    calloutWrapperStyles: (0, _css.css)({
      borderRadius: euiTheme.border.radius.medium,
      border: `1px solid ${euiTheme.colors.lightShade}`,
      padding: `${euiTheme.size.xs} ${euiTheme.size.m}`,
      backgroundColor,
      marginTop: euiTheme.size.base
    }),
    calloutTitleStyles: (0, _css.css)({
      color: euiTheme.colors.title,
      fontSize: euiTheme.size.m,
      fontWeight: euiTheme.font.weight.regular,
      lineHeight: `${euiTheme.base * 1.25}px`,
      marginLeft: euiTheme.size.xs
    }),
    calloutAnchorStyles: (0, _css.css)({
      marginLeft: euiTheme.size.s
    })
  }), [backgroundColor, euiTheme.base, euiTheme.border.radius.medium, euiTheme.colors.lightShade, euiTheme.colors.title, euiTheme.font.weight.regular, euiTheme.size.base, euiTheme.size.m, euiTheme.size.s, euiTheme.size.xs]);
  return customStyles;
};
exports.useAddIntegrationsCalloutStyles = useAddIntegrationsCalloutStyles;