"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStorageKeyBySpace = exports.defaultExpandedCards = exports.OnboardingStorage = exports.FINISHED_STEPS_STORAGE_KEY = exports.EXPANDED_CARDS_STORAGE_KEY = exports.ACTIVE_PRODUCTS_STORAGE_KEY = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _types = require("./types");
var _helpers = require("./helpers");
var _sections = require("./sections");
var _local_storage = require("../../../lib/local_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTIVE_PRODUCTS_STORAGE_KEY = exports.ACTIVE_PRODUCTS_STORAGE_KEY = 'securitySolution.getStarted.activeProducts';
const FINISHED_STEPS_STORAGE_KEY = exports.FINISHED_STEPS_STORAGE_KEY = 'securitySolution.getStarted.finishedSteps';
const EXPANDED_CARDS_STORAGE_KEY = exports.EXPANDED_CARDS_STORAGE_KEY = 'securitySolution.getStarted.expandedCards';
const getStorageKeyBySpace = (storageKey, spaceId) => {
  if (spaceId == null) {
    return storageKey;
  }
  return `${storageKey}.${spaceId}`;
};
exports.getStorageKeyBySpace = getStorageKeyBySpace;
const defaultExpandedCards = exports.defaultExpandedCards = {
  [_types.QuickStartSectionCardsId.watchTheOverviewVideo]: {
    isExpanded: false,
    expandedSteps: []
  },
  [_types.QuickStartSectionCardsId.createFirstProject]: {
    isExpanded: false,
    expandedSteps: []
  },
  [_types.AddAndValidateYourDataCardsId.addIntegrations]: {
    isExpanded: false,
    expandedSteps: []
  },
  [_types.AddAndValidateYourDataCardsId.viewDashboards]: {
    isExpanded: false,
    expandedSteps: []
  },
  [_types.GetStartedWithAlertsCardsId.enablePrebuiltRules]: {
    isExpanded: false,
    expandedSteps: []
  },
  [_types.GetStartedWithAlertsCardsId.viewAlerts]: {
    isExpanded: false,
    expandedSteps: []
  }
};
class OnboardingStorage {
  constructor(spaceId) {
    (0, _defineProperty2.default)(this, "finishedStepsStorageKey", void 0);
    (0, _defineProperty2.default)(this, "activeProductsStorageKey", void 0);
    (0, _defineProperty2.default)(this, "expandedCardsStorageKey", void 0);
    (0, _defineProperty2.default)(this, "setDefaultFinishedSteps", cardId => {
      var _allFinishedSteps$car;
      const finishedStepsStorageKey = this.finishedStepsStorageKey;
      const allFinishedSteps = _local_storage.storage.get(finishedStepsStorageKey);
      const defaultFinishedStepsByCardId = _helpers.DEFAULT_FINISHED_STEPS[cardId];
      const hasDefaultFinishedSteps = defaultFinishedStepsByCardId != null;
      if (!hasDefaultFinishedSteps) {
        return;
      }
      _local_storage.storage.set(finishedStepsStorageKey, {
        ...allFinishedSteps,
        [cardId]: Array.from(
        // dedupe card steps
        new Set([...(defaultFinishedStepsByCardId !== null && defaultFinishedStepsByCardId !== void 0 ? defaultFinishedStepsByCardId : []), ...((_allFinishedSteps$car = allFinishedSteps[cardId]) !== null && _allFinishedSteps$car !== void 0 ? _allFinishedSteps$car : [])]))
      });
    });
    (0, _defineProperty2.default)(this, "getActiveProductsFromStorage", () => {
      const activeProductsStorageKey = this.activeProductsStorageKey;
      const activeProducts = _local_storage.storage.get(activeProductsStorageKey);
      return activeProducts !== null && activeProducts !== void 0 ? activeProducts : [];
    });
    (0, _defineProperty2.default)(this, "toggleActiveProductsInStorage", productId => {
      var _storage$get;
      const activeProductsStorageKey = this.activeProductsStorageKey;
      const activeProducts = (_storage$get = _local_storage.storage.get(activeProductsStorageKey)) !== null && _storage$get !== void 0 ? _storage$get : [];
      const index = activeProducts.indexOf(productId);
      if (index < 0) {
        activeProducts.push(productId);
      } else {
        activeProducts.splice(index, 1);
      }
      _local_storage.storage.set(activeProductsStorageKey, activeProducts);
      return activeProducts;
    });
    (0, _defineProperty2.default)(this, "getFinishedStepsFromStorageByCardId", cardId => {
      var _finishedSteps$cardId;
      const finishedSteps = this.getAllFinishedStepsFromStorage();
      const steps = (_finishedSteps$cardId = finishedSteps[cardId]) !== null && _finishedSteps$cardId !== void 0 ? _finishedSteps$cardId : [];
      return steps;
    });
    (0, _defineProperty2.default)(this, "getAllFinishedStepsFromStorage", () => {
      const finishedStepsStorageKey = this.finishedStepsStorageKey;
      const allFinishedSteps = _local_storage.storage.get(finishedStepsStorageKey);
      if (allFinishedSteps == null) {
        _local_storage.storage.set(finishedStepsStorageKey, _helpers.DEFAULT_FINISHED_STEPS);
      } else {
        (0, _sections.getSections)().forEach(section => {
          var _section$cards;
          (_section$cards = section.cards) === null || _section$cards === void 0 ? void 0 : _section$cards.forEach(card => {
            this.setDefaultFinishedSteps(card.id);
          });
        });
      }
      return _local_storage.storage.get(finishedStepsStorageKey);
    });
    (0, _defineProperty2.default)(this, "addFinishedStepToStorage", (cardId, stepId) => {
      var _finishedSteps$cardId2;
      const finishedStepsStorageKey = this.finishedStepsStorageKey;
      const finishedSteps = this.getAllFinishedStepsFromStorage();
      const card = (_finishedSteps$cardId2 = finishedSteps[cardId]) !== null && _finishedSteps$cardId2 !== void 0 ? _finishedSteps$cardId2 : [];
      if (card.indexOf(stepId) < 0) {
        card.push(stepId);
        _local_storage.storage.set(finishedStepsStorageKey, {
          ...finishedSteps,
          [cardId]: card
        });
      }
    });
    (0, _defineProperty2.default)(this, "removeFinishedStepFromStorage", (cardId, stepId, onboardingSteps) => {
      var _finishedSteps$cardId3;
      if ((0, _helpers.isDefaultFinishedCardStep)(cardId, stepId, onboardingSteps)) {
        return;
      }
      const finishedStepsStorageKey = this.finishedStepsStorageKey;
      const finishedSteps = this.getAllFinishedStepsFromStorage();
      const steps = (_finishedSteps$cardId3 = finishedSteps[cardId]) !== null && _finishedSteps$cardId3 !== void 0 ? _finishedSteps$cardId3 : [];
      const index = steps.indexOf(stepId);
      if (index >= 0) {
        steps.splice(index, 1);
      }
      _local_storage.storage.set(finishedStepsStorageKey, {
        ...finishedSteps,
        [cardId]: steps
      });
    });
    (0, _defineProperty2.default)(this, "getAllExpandedCardStepsFromStorage", () => {
      const expandedCardsStorageKey = this.expandedCardsStorageKey;
      const storageData = _local_storage.storage.get(expandedCardsStorageKey);
      return !storageData || Object.keys(storageData).length === 0 ? defaultExpandedCards : storageData;
    });
    (0, _defineProperty2.default)(this, "resetAllExpandedCardStepsToStorage", () => {
      const activeCards = this.getAllExpandedCardStepsFromStorage();
      const expandedCardsStorageKey = this.expandedCardsStorageKey;
      _local_storage.storage.set(expandedCardsStorageKey, Object.entries(activeCards).reduce((acc, [cardId, card]) => {
        var _defaultExpandedCards;
        acc[cardId] = (_defaultExpandedCards = defaultExpandedCards[cardId]) !== null && _defaultExpandedCards !== void 0 ? _defaultExpandedCards : card;
        return acc;
      }, {}));
    });
    (0, _defineProperty2.default)(this, "addExpandedCardStepToStorage", (cardId, stepId) => {
      const activeCards = this.getAllExpandedCardStepsFromStorage();
      const expandedCardsStorageKey = this.expandedCardsStorageKey;
      const card = activeCards[cardId] ? {
        expandedSteps: [stepId],
        isExpanded: true
      } : {
        isExpanded: false,
        expandedSteps: []
      };
      _local_storage.storage.set(expandedCardsStorageKey, {
        ...activeCards,
        [cardId]: card
      });
    });
    (0, _defineProperty2.default)(this, "removeExpandedCardStepFromStorage", (cardId, stepId) => {
      var _storage$get2;
      const expandedCardsStorageKey = this.expandedCardsStorageKey;
      const activeCards = (_storage$get2 = _local_storage.storage.get(expandedCardsStorageKey)) !== null && _storage$get2 !== void 0 ? _storage$get2 : {};
      const card = activeCards[cardId];
      if (card && !stepId) {
        card.isExpanded = false;
      }
      if (card && stepId) {
        const index = card.expandedSteps.indexOf(stepId);
        if (index >= 0) {
          card.expandedSteps.splice(index, 1);
          card.isExpanded = false;
        }
      }
      _local_storage.storage.set(expandedCardsStorageKey, {
        ...activeCards,
        [cardId]: card
      });
    });
    this.finishedStepsStorageKey = getStorageKeyBySpace(FINISHED_STEPS_STORAGE_KEY, spaceId);
    this.activeProductsStorageKey = getStorageKeyBySpace(ACTIVE_PRODUCTS_STORAGE_KEY, spaceId);
    this.expandedCardsStorageKey = getStorageKeyBySpace(EXPANDED_CARDS_STORAGE_KEY, spaceId);
  }
}
exports.OnboardingStorage = OnboardingStorage;