"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageProjectsButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("./translations");
var _use_projects_url = require("../hooks/use_projects_url");
var _links = require("../../../links");
var _step_context = require("../context/step_context");
var _types = require("../types");
var _types2 = require("./types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManageProjectsButtonComponent = () => {
  const projectsUrl = (0, _use_projects_url.useProjectsUrl)();
  const {
    onStepLinkClicked
  } = (0, _step_context.useStepContext)();
  const onClick = (0, _react.useCallback)(() => {
    onStepLinkClicked({
      originStepId: _types.CreateProjectSteps.createFirstProject,
      stepLinkId: _types2.ManageProjectsStepLinkId
    });
  }, [onStepLinkClicked]);
  return projectsUrl ? /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
    "aria-label": _translations.MANAGE_PROJECTS,
    className: "step-paragraph",
    fill: true,
    href: projectsUrl,
    target: "_blank",
    onClick: onClick
  }, _translations.MANAGE_PROJECTS, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout"
  })) : null;
};
const ManageProjectsButton = exports.ManageProjectsButton = /*#__PURE__*/_react.default.memo(ManageProjectsButtonComponent);