"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddIntegrationCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _classnames = _interopRequireDefault(require("classnames"));
var _add_integrations_callout = require("../styles/add_integrations_callout.styles");
var _translations = require("./translations");
var _types = require("../types");
var _step_context = require("../context/step_context");
var _types2 = require("./types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddIntegrationsCalloutComponent = ({
  stepName,
  stepId
}) => {
  const {
    calloutWrapperStyles,
    calloutTitleStyles,
    calloutAnchorStyles
  } = (0, _add_integrations_callout.useAddIntegrationsCalloutStyles)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    navigateTo
  } = (0, _securitySolutionNavigation.useNavigateTo)();
  const {
    onStepLinkClicked
  } = (0, _step_context.useStepContext)();
  const onClick = (0, _react.useCallback)(() => {
    navigateTo({
      deepLinkId: _securitySolutionNavigation.SecurityPageName.landing,
      path: `#${_types.AddIntegrationsSteps.connectToDataSources}`
    });
    onStepLinkClicked({
      originStepId: stepId,
      stepLinkId: _types2.AddIntegrationCalloutStepLinkId
    });
  }, [navigateTo, onStepLinkClicked, stepId]);
  const classNames = (0, _classnames.default)('add-integrations-callout', calloutWrapperStyles);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    className: classNames,
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "iInCircle",
      color: euiTheme.colors.title,
      className: "eui-alignMiddle"
    }), /*#__PURE__*/_react.default.createElement("span", {
      className: calloutTitleStyles
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.onboarding.addIntegrationCallout.description",
      defaultMessage: "To {stepName} add integrations first {addIntegration}",
      values: {
        addIntegration: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: onClick,
          className: calloutAnchorStyles
        }, _translations.ADD_INTEGRATIONS_STEP, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "arrowRight",
          size: "s",
          className: calloutAnchorStyles
        })),
        stepName: stepName !== null && stepName !== void 0 ? stepName : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.onboarding.addIntegrationCallout.link.action",
          defaultMessage: "enable this step"
        })
      }
    }))),
    size: "s"
  });
};
const AddIntegrationCallout = exports.AddIntegrationCallout = /*#__PURE__*/_react.default.memo(AddIntegrationsCalloutComponent);