"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = exports.getFinishedStepsInitialStates = exports.getActiveSectionsInitialStates = exports.getActiveProductsInitialStates = void 0;
var _helpers = require("./helpers");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reducer = (state, action) => {
  if (action.type === _types.OnboardingActions.ToggleProduct) {
    const activeProducts = new Set([...state.activeProducts]);
    if (activeProducts.has(action.payload.section)) {
      activeProducts.delete(action.payload.section);
    } else {
      activeProducts.add(action.payload.section);
    }
    const {
      activeSections,
      totalStepsLeft,
      totalActiveSteps
    } = (0, _helpers.setupActiveSections)(state.finishedSteps, activeProducts, state.onboardingSteps);
    return {
      ...state,
      activeProducts,
      activeSections,
      totalStepsLeft,
      totalActiveSteps
    };
  }
  if (action.type === _types.OnboardingActions.AddFinishedStep) {
    const finishedSteps = {
      ...state.finishedSteps,
      [action.payload.cardId]: state.finishedSteps[action.payload.cardId] ? new Set([...state.finishedSteps[action.payload.cardId]]) : new Set()
    };
    finishedSteps[action.payload.cardId].add(action.payload.stepId);
    const {
      activeSections,
      totalStepsLeft,
      totalActiveSteps
    } = (0, _helpers.updateActiveSections)({
      activeProducts: state.activeProducts,
      activeSections: state.activeSections,
      cardId: action.payload.cardId,
      finishedSteps,
      sectionId: action.payload.sectionId,
      onboardingSteps: state.onboardingSteps
    });
    return {
      ...state,
      finishedSteps,
      activeSections,
      totalStepsLeft,
      totalActiveSteps
    };
  }
  if (action.type === _types.OnboardingActions.RemoveFinishedStep) {
    const finishedSteps = {
      ...state.finishedSteps,
      [action.payload.cardId]: state.finishedSteps[action.payload.cardId] ? new Set([...state.finishedSteps[action.payload.cardId]]) : new Set()
    };
    finishedSteps[action.payload.cardId].delete(action.payload.stepId);
    const {
      activeSections,
      totalStepsLeft,
      totalActiveSteps
    } = (0, _helpers.updateActiveSections)({
      activeProducts: state.activeProducts,
      activeSections: state.activeSections,
      cardId: action.payload.cardId,
      finishedSteps,
      sectionId: action.payload.sectionId,
      onboardingSteps: state.onboardingSteps
    });
    return {
      ...state,
      finishedSteps,
      activeSections,
      totalStepsLeft,
      totalActiveSteps
    };
  }
  if (action.type === _types.OnboardingActions.ToggleExpandedStep && action.payload.isStepExpanded != null) {
    // It allows Only One step open at a time
    const expandedSteps = new Set();
    if (action.payload.isStepExpanded === true && action.payload.stepId != null) {
      return {
        ...state,
        expandedCardSteps: Object.entries(state.expandedCardSteps).reduce((acc, [cardId, card]) => {
          if (cardId === action.payload.cardId) {
            expandedSteps.add(action.payload.stepId);
            acc[action.payload.cardId] = {
              expandedSteps: [...expandedSteps],
              isExpanded: true
            };
          } else {
            // Remove all other expanded steps in other cards
            acc[cardId] = {
              expandedSteps: [],
              isExpanded: false
            };
          }
          return acc;
        }, {})
      };
    }
    if (action.payload.isStepExpanded === false) {
      expandedSteps.delete(action.payload.stepId);
      return {
        ...state,
        expandedCardSteps: {
          ...state.expandedCardSteps,
          [action.payload.cardId]: {
            expandedSteps: [],
            isExpanded: false
          }
        }
      };
    }
  }
  return state;
};
exports.reducer = reducer;
const getFinishedStepsInitialStates = ({
  finishedSteps
}) => {
  const initialStates = Object.entries(finishedSteps).reduce((acc, [cardId, stepIdsByCard]) => {
    if (stepIdsByCard) {
      acc[cardId] = new Set(stepIdsByCard);
    }
    return acc;
  }, {});
  return initialStates;
};
exports.getFinishedStepsInitialStates = getFinishedStepsInitialStates;
const getActiveProductsInitialStates = ({
  activeProducts
}) => new Set(activeProducts);
exports.getActiveProductsInitialStates = getActiveProductsInitialStates;
const getActiveSectionsInitialStates = ({
  activeProducts,
  finishedSteps,
  onboardingSteps
}) => (0, _helpers.setupActiveSections)(finishedSteps, activeProducts, onboardingSteps);
exports.getActiveSectionsInitialStates = getActiveSectionsInitialStates;