"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductSwitch = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = _interopRequireWildcard(require("react"));
var _configs = require("./configs");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const switches = [{
  id: _configs.ProductLine.security,
  label: i18n.ANALYTICS_SWITCH_LABEL
}, {
  id: _configs.ProductLine.cloud,
  label: i18n.CLOUD_SWITCH_LABEL
}, {
  id: _configs.ProductLine.endpoint,
  label: i18n.ENDPOINT_SWITCH_LABEL
}];
const ProductSwitchComponent = ({
  onProductSwitchChanged,
  activeProducts,
  euiTheme
}) => {
  const switchNodes = (0, _react.useMemo)(() => switches.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    key: item.id,
    "data-test-subj": item.id,
    label: item.label,
    onChange: () => onProductSwitchChanged(item),
    css: (0, _css.css)`
            padding-left: ${euiTheme.base * 0.625}px;
          `,
    checked: activeProducts.has(item.id)
  })), [activeProducts, euiTheme.base, onProductSwitchChanged]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "product-switch",
    color: "plain",
    element: "div",
    grow: false,
    paddingSize: "none",
    hasShadow: false,
    css: (0, _css.css)`
        padding: ${euiTheme.base * 1.25}px 0;
      `,
    borderRadius: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    css: (0, _css.css)`
          padding-right: ${euiTheme.size.xs};
        `
  }, /*#__PURE__*/_react.default.createElement("strong", null, i18n.TOGGLE_PANEL_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "eui-displayInline"
  }, switchNodes));
};
ProductSwitchComponent.displayName = 'ProductSwitchComponent';
const ProductSwitch = exports.ProductSwitch = ProductSwitchComponent;