"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingComponent = exports.Onboarding = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _toggle_panel = require("./toggle_panel");
var _use_toggle_panel = require("./hooks/use_toggle_panel");
var _progress_bar = require("./progress_bar");
var _step_context = require("./context/step_context");
var _helpers = require("./helpers");
var _welcome_header = require("./welcome_header");
var _footer = require("./footer");
var _use_scroll = require("./hooks/use_scroll");
var _configs = require("./configs");
var _onboarding = require("./styles/onboarding.styles");
var _kibana = require("../../../lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OnboardingComponent = ({
  indicesExist,
  productTypes,
  onboardingSteps,
  spaceId
}) => {
  const {
    onStepClicked,
    toggleTaskCompleteStatus,
    state: {
      activeProducts,
      activeSections,
      finishedSteps,
      totalActiveSteps,
      totalStepsLeft,
      expandedCardSteps
    }
  } = (0, _use_toggle_panel.useTogglePanel)({
    productTypes,
    onboardingSteps,
    spaceId
  });
  const productTier = (0, _react.useMemo)(() => {
    var _productTypes$find;
    return productTypes === null || productTypes === void 0 ? void 0 : (_productTypes$find = productTypes.find(product => product.product_line === _configs.ProductLine.security)) === null || _productTypes$find === void 0 ? void 0 : _productTypes$find.product_tier;
  }, [productTypes]);
  const {
    wrapperStyles,
    progressSectionStyles,
    stepsSectionStyles
  } = (0, _onboarding.useOnboardingStyles)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const onStepLinkClicked = (0, _react.useCallback)(params => {
    telemetry.reportOnboardingHubStepLinkClicked(params);
  }, [telemetry]);
  (0, _use_scroll.useScrollToHash)();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: wrapperStyles
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    restrictWidth: _helpers.CONTENT_WIDTH,
    paddingSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_welcome_header.WelcomeHeader, {
    productTier: productTier
  })), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    restrictWidth: _helpers.CONTENT_WIDTH,
    paddingSize: "none",
    className: progressSectionStyles
  }, /*#__PURE__*/_react.default.createElement(_progress_bar.Progress, {
    totalActiveSteps: totalActiveSteps,
    totalStepsLeft: totalStepsLeft,
    productTier: productTier
  })), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    bottomBorder: "extended",
    grow: true,
    restrictWidth: _helpers.CONTENT_WIDTH,
    paddingSize: "none",
    className: stepsSectionStyles
  }, /*#__PURE__*/_react.default.createElement(_step_context.StepContextProvider, {
    expandedCardSteps: expandedCardSteps,
    finishedSteps: finishedSteps,
    indicesExist: !!indicesExist,
    onStepClicked: onStepClicked,
    onStepLinkClicked: onStepLinkClicked,
    toggleTaskCompleteStatus: toggleTaskCompleteStatus
  }, /*#__PURE__*/_react.default.createElement(_toggle_panel.TogglePanel, {
    activeProducts: activeProducts,
    activeSections: activeSections
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    grow: true,
    restrictWidth: _helpers.CONTENT_WIDTH,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_footer.Footer, null)));
};
exports.OnboardingComponent = OnboardingComponent;
const Onboarding = exports.Onboarding = /*#__PURE__*/_react.default.memo(OnboardingComponent);