"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProjectsUrl = void 0;
var _reactUse = require("react-use");
var _kibana = require("../../../../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useProjectsUrl = () => {
  const {
    projectsUrl$
  } = (0, _kibana.useKibana)().services.onboarding;
  return (0, _reactUse.useObservable)(projectsUrl$, undefined);
};
exports.useProjectsUrl = useProjectsUrl;