"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateActiveSections = exports.setupActiveSections = exports.isStepActive = exports.isDefaultFinishedCardStep = exports.getTotalStepsLeftAndActiveSteps = exports.getStepsByActiveProduct = exports.getCardTimeInMinutes = exports.getCardStepsLeft = exports.getCard = exports.getActiveSteps = exports.findCardSectionByStepId = exports.DEFAULT_FINISHED_STEPS = exports.CONTENT_WIDTH = void 0;
var _sections = require("./sections");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CONTENT_WIDTH = exports.CONTENT_WIDTH = 1150;
const DEFAULT_FINISHED_STEPS = exports.DEFAULT_FINISHED_STEPS = {
  [_types.QuickStartSectionCardsId.createFirstProject]: [_types.CreateProjectSteps.createFirstProject]
};
const isDefaultFinishedCardStep = (cardId, stepId, onboardingSteps) => {
  var _DEFAULT_FINISHED_STE;
  return !!((_DEFAULT_FINISHED_STE = DEFAULT_FINISHED_STEPS[cardId]) !== null && _DEFAULT_FINISHED_STE !== void 0 && _DEFAULT_FINISHED_STE.includes(stepId)) && (onboardingSteps === null || onboardingSteps === void 0 ? void 0 : onboardingSteps.includes(stepId));
};
exports.isDefaultFinishedCardStep = isDefaultFinishedCardStep;
const getCardTimeInMinutes = (activeSteps, stepsDone) => {
  var _activeSteps$reduce;
  return (_activeSteps$reduce = activeSteps === null || activeSteps === void 0 ? void 0 : activeSteps.reduce((totalMin, {
    timeInMinutes,
    id: stepId
  }) => totalMin + (stepsDone.has(stepId) ? 0 : timeInMinutes !== null && timeInMinutes !== void 0 ? timeInMinutes : 0), 0)) !== null && _activeSteps$reduce !== void 0 ? _activeSteps$reduce : 0;
};
exports.getCardTimeInMinutes = getCardTimeInMinutes;
const getCardStepsLeft = (activeSteps, stepsDone) => {
  var _activeSteps$length, _stepsDone$size;
  return Math.max(((_activeSteps$length = activeSteps === null || activeSteps === void 0 ? void 0 : activeSteps.length) !== null && _activeSteps$length !== void 0 ? _activeSteps$length : 0) - ((_stepsDone$size = stepsDone.size) !== null && _stepsDone$size !== void 0 ? _stepsDone$size : 0), 0);
};
exports.getCardStepsLeft = getCardStepsLeft;
const isStepActive = (step, activeProducts) => {
  var _step$productLineRequ;
  return !step.productLineRequired || ((_step$productLineRequ = step.productLineRequired) === null || _step$productLineRequ === void 0 ? void 0 : _step$productLineRequ.some(condition => activeProducts.has(condition)));
};
exports.isStepActive = isStepActive;
const getActiveSteps = (steps, activeProducts, onboardingSteps) => steps === null || steps === void 0 ? void 0 : steps.filter(step => onboardingSteps.includes(step.id) && isStepActive(step, activeProducts));
exports.getActiveSteps = getActiveSteps;
const getfinishedActiveSteps = (finishedStepIds, activeStepIds) => {
  const finishedActiveSteps = finishedStepIds === null || finishedStepIds === void 0 ? void 0 : finishedStepIds.reduce((acc, finishedStepId) => {
    const activeFinishedStepId = activeStepIds === null || activeStepIds === void 0 ? void 0 : activeStepIds.find(activeStepId => finishedStepId === activeStepId);
    if (activeFinishedStepId) {
      acc.push(activeFinishedStepId);
    }
    return acc;
  }, []);
  return new Set(finishedActiveSteps);
};
const findCardSectionByStepId = stepId => {
  var _cards$find, _getSections$find;
  const cards = (0, _sections.getSections)().flatMap(s => s.cards);
  let matchedStep = null;
  const matchedCard = (_cards$find = cards.find(c => {
    var _c$steps;
    return !!((_c$steps = c.steps) !== null && _c$steps !== void 0 && _c$steps.find(step => {
      if (stepId === step.id) {
        matchedStep = step;
        return true;
      } else {
        return false;
      }
    }));
  })) !== null && _cards$find !== void 0 ? _cards$find : null;
  const matchedSection = matchedCard ? (_getSections$find = (0, _sections.getSections)().find(s => {
    var _s$cards;
    return (_s$cards = s.cards) === null || _s$cards === void 0 ? void 0 : _s$cards.includes(matchedCard);
  })) !== null && _getSections$find !== void 0 ? _getSections$find : null : null;
  return {
    matchedCard,
    matchedStep,
    matchedSection
  };
};
exports.findCardSectionByStepId = findCardSectionByStepId;
const getCard = ({
  cardId,
  sectionId
}) => {
  const sections = (0, _sections.getSections)();
  const section = sections.find(({
    id
  }) => id === sectionId);
  const cards = section === null || section === void 0 ? void 0 : section.cards;
  const card = cards === null || cards === void 0 ? void 0 : cards.find(({
    id
  }) => id === cardId);
  return card;
};
exports.getCard = getCard;
const getStepsByActiveProduct = ({
  activeProducts,
  cardId,
  sectionId,
  onboardingSteps
}) => {
  const card = getCard({
    cardId,
    sectionId
  });
  const steps = getActiveSteps(card === null || card === void 0 ? void 0 : card.steps, activeProducts, onboardingSteps);
  return steps;
};
exports.getStepsByActiveProduct = getStepsByActiveProduct;
const setupActiveSections = (finishedSteps, activeProducts, onboardingSteps) => activeProducts.size > 0 ? (0, _sections.getSections)().reduce((acc, section) => {
  var _section$cards$reduce, _section$cards;
  const activeCards = (_section$cards$reduce = (_section$cards = section.cards) === null || _section$cards === void 0 ? void 0 : _section$cards.reduce((accCards, card) => {
    var _activeStepIds$length;
    const activeSteps = getActiveSteps(card.steps, activeProducts, onboardingSteps);
    const activeStepIds = activeSteps === null || activeSteps === void 0 ? void 0 : activeSteps.map(({
      id
    }) => id);
    const stepsDone = getfinishedActiveSteps(finishedSteps[card.id] ? [...finishedSteps[card.id]] : undefined, activeStepIds);
    const timeInMins = getCardTimeInMinutes(activeSteps, stepsDone);
    const stepsLeft = getCardStepsLeft(activeSteps, stepsDone);
    acc.totalStepsLeft += stepsLeft;
    acc.totalActiveSteps += (_activeStepIds$length = activeStepIds === null || activeStepIds === void 0 ? void 0 : activeStepIds.length) !== null && _activeStepIds$length !== void 0 ? _activeStepIds$length : 0;
    if (activeSteps && activeSteps.length > 0) {
      accCards[card.id] = {
        id: card.id,
        timeInMins,
        stepsLeft,
        activeStepIds
      };
    }
    return accCards;
  }, {})) !== null && _section$cards$reduce !== void 0 ? _section$cards$reduce : {};
  if (Object.keys(activeCards).length > 0) {
    acc.activeSections[section.id] = activeCards;
  }
  return acc;
}, {
  activeSections: {},
  totalStepsLeft: 0,
  totalActiveSteps: 0
}) : {
  activeSections: null,
  totalStepsLeft: null,
  totalActiveSteps: null
};
exports.setupActiveSections = setupActiveSections;
const updateActiveSections = ({
  activeProducts,
  activeSections,
  cardId,
  finishedSteps,
  onboardingSteps,
  sectionId
}) => {
  const activeSection = activeSections ? activeSections[sectionId] : undefined;
  const activeCard = activeSection ? activeSection[cardId] : undefined;
  if (!activeCard || !activeSections) {
    return {
      activeSections,
      totalActiveSteps: null,
      totalStepsLeft: null
    };
  }
  const steps = getStepsByActiveProduct({
    activeProducts,
    cardId,
    sectionId,
    onboardingSteps
  });
  const activeStepIds = activeCard.activeStepIds;
  const stepsDone = getfinishedActiveSteps(finishedSteps[cardId] ? [...finishedSteps[cardId]] : undefined, activeStepIds);
  const timeInMins = getCardTimeInMinutes(steps, stepsDone);
  const stepsLeft = getCardStepsLeft(steps, stepsDone);
  const newActiveSections = {
    ...activeSections,
    [sectionId]: {
      ...activeSections[sectionId],
      ...(activeStepIds && (activeStepIds === null || activeStepIds === void 0 ? void 0 : activeStepIds.length) > 0 ? {
        [cardId]: {
          id: cardId,
          timeInMins,
          stepsLeft,
          activeStepIds
        }
      } : {})
    }
  };
  const {
    totalStepsLeft,
    totalActiveSteps
  } = Object.values(newActiveSections).reduce((acc, newActiveSection) => {
    Object.values(newActiveSection).forEach(newActiveCard => {
      var _newActiveCard$active, _newActiveCard$active2;
      acc.totalStepsLeft += newActiveCard.stepsLeft;
      acc.totalActiveSteps += (_newActiveCard$active = newActiveCard === null || newActiveCard === void 0 ? void 0 : (_newActiveCard$active2 = newActiveCard.activeStepIds) === null || _newActiveCard$active2 === void 0 ? void 0 : _newActiveCard$active2.length) !== null && _newActiveCard$active !== void 0 ? _newActiveCard$active : 0;
    }, {
      totalStepsLeft: 0,
      totalActiveSteps: 0
    });
    return acc;
  }, {
    totalStepsLeft: 0,
    totalActiveSteps: 0
  });
  return {
    activeSections: newActiveSections,
    totalStepsLeft,
    totalActiveSteps
  };
};
exports.updateActiveSections = updateActiveSections;
const getTotalStepsLeftAndActiveSteps = activeSections => Object.values(activeSections !== null && activeSections !== void 0 ? activeSections : {}).reduce((acc, activeSection) => {
  Object.values(activeSection).forEach(newActiveCard => {
    var _newActiveCard$active3, _newActiveCard$active4;
    acc.totalStepsLeft += newActiveCard.stepsLeft;
    acc.totalActiveSteps += (_newActiveCard$active3 = newActiveCard === null || newActiveCard === void 0 ? void 0 : (_newActiveCard$active4 = newActiveCard.activeStepIds) === null || _newActiveCard$active4 === void 0 ? void 0 : _newActiveCard$active4.length) !== null && _newActiveCard$active3 !== void 0 ? _newActiveCard$active3 : 0;
  }, {
    totalStepsLeft: 0,
    totalActiveSteps: 0
  });
  return acc;
}, {
  totalStepsLeft: 0,
  totalActiveSteps: 0
});
exports.getTotalStepsLeftAndActiveSteps = getTotalStepsLeftAndActiveSteps;