"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepContent = void 0;
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
var _use_check_step_completed = require("../hooks/use_check_step_completed");
var _step_content = require("../styles/step_content.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepContentComponent = ({
  autoCheckIfStepCompleted,
  cardId,
  indicesExist,
  sectionId,
  step,
  toggleTaskCompleteStatus
}) => {
  const {
    id: stepId,
    splitPanel
  } = step;
  const {
    stepContentGroupStyles,
    leftContentStyles,
    descriptionStyles,
    rightPanelStyles,
    rightPanelContentStyles
  } = (0, _step_content.useStepContentStyles)();
  (0, _use_check_step_completed.useCheckStepCompleted)({
    autoCheckIfStepCompleted,
    cardId,
    indicesExist,
    sectionId,
    stepId,
    stepTitle: step.title,
    toggleTaskCompleteStatus
  });
  const stepContentGroupClassName = (0, _classnames.default)('step-content-group', stepContentGroupStyles);
  const leftContentClassNames = (0, _classnames.default)('left-panel', leftContentStyles);
  const descriptionClassNames = (0, _classnames.default)('step-content-description', 'eui-displayBlock', descriptionStyles);
  const rightPanelClassNames = (0, _classnames.default)('right-panel', rightPanelStyles);
  const rightPanelContentClassNames = (0, _classnames.default)('right-panel-wrapper', rightPanelContentStyles);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    color: "plain",
    className: stepContentGroupClassName,
    "data-test-subj": `${stepId}-content`,
    direction: "row",
    gutterSize: "none"
  }, step.description && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: leftContentClassNames
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, step.description.map((desc, index) => /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${stepId}-description-${index}`,
    key: `${stepId}-description-${index}`,
    className: descriptionClassNames
  }, desc)))), splitPanel && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "split-panel",
    className: rightPanelClassNames
  }, splitPanel && /*#__PURE__*/_react.default.createElement("div", {
    className: rightPanelContentClassNames
  }, splitPanel)));
};
const StepContent = exports.StepContent = /*#__PURE__*/_react.default.memo(StepContentComponent);