"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardStep = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _translations = require("../translations");
var _step_content = require("./step_content");
var _use_check_step_completed = require("../hooks/use_check_step_completed");
var _step_context = require("../context/step_context");
var _card_step = require("../styles/card_step.styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CardStepComponent = ({
  cardId,
  expandedSteps,
  finishedSteps = new Set(),
  toggleTaskCompleteStatus,
  onStepClicked,
  sectionId,
  step
}) => {
  const {
    navigateTo
  } = (0, _securitySolutionNavigation.useNavigateTo)();
  const isExpandedStep = expandedSteps.has(step.id);
  const {
    id: stepId,
    title,
    description,
    splitPanel,
    icon,
    autoCheckIfStepCompleted
  } = step;
  const hasStepContent = description != null || splitPanel != null;
  const {
    indicesExist
  } = (0, _step_context.useStepContext)();
  (0, _use_check_step_completed.useCheckStepCompleted)({
    autoCheckIfStepCompleted,
    cardId,
    indicesExist,
    sectionId,
    stepId,
    stepTitle: title,
    toggleTaskCompleteStatus
  });
  const isDone = finishedSteps.has(stepId);
  const toggleStep = (0, _react.useCallback)(e => {
    e.preventDefault();
    const newStatus = !isExpandedStep;
    if (hasStepContent) {
      // Toggle step and sync the expanded card step to storage & reducer
      onStepClicked({
        stepId,
        cardId,
        sectionId,
        isExpanded: newStatus,
        trigger: 'click'
      });
      navigateTo({
        deepLinkId: _securitySolutionNavigation.SecurityPageName.landing,
        path: newStatus ? `#${stepId}` : undefined
      });
    }
  }, [isExpandedStep, hasStepContent, onStepClicked, stepId, cardId, sectionId, navigateTo]);
  const {
    stepPanelStyles,
    stepIconStyles,
    stepTitleStyles,
    allDoneTextStyles,
    toggleButtonStyles,
    getStepGroundStyles,
    stepItemStyles
  } = (0, _card_step.useCardStepStyles)();
  const stepGroundStyles = getStepGroundStyles({
    hasStepContent
  });
  const panelClassNames = (0, _classnames.default)({
    'step-panel-collapsed': !isExpandedStep
  }, stepPanelStyles);
  const stepIconClassNames = (0, _classnames.default)('step-icon', {
    'step-icon-done': isDone,
    stepIconStyles
  });
  const stepTitleClassNames = (0, _classnames.default)('step-title', stepTitleStyles);
  const allDoneTextNames = (0, _classnames.default)('all-done-badge', allDoneTextStyles);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "plain",
    grow: false,
    hasShadow: false,
    borderRadius: "none",
    paddingSize: "none",
    className: panelClassNames,
    id: stepId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    className: stepGroundStyles
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    onClick: toggleStep,
    className: stepItemStyles
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: stepIconClassNames
  }, icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({}, icon, {
    size: "l",
    className: "eui-alignMiddle"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    onClick: toggleStep,
    className: stepItemStyles
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: stepTitleClassNames
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: stepItemStyles
  }, /*#__PURE__*/_react.default.createElement("div", null, isDone && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: allDoneTextNames,
    color: "success"
  }, _translations.ALL_DONE_TEXT), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: "eui-displayInlineBlock toggle-button",
    color: "primary",
    onClick: toggleStep,
    iconType: isExpandedStep ? 'arrowUp' : 'arrowDown',
    "aria-label": isExpandedStep ? _translations.COLLAPSE_STEP_BUTTON_LABEL : _translations.EXPAND_STEP_BUTTON_LABEL,
    size: "xs",
    css: toggleButtonStyles,
    isDisabled: !hasStepContent
  })))), hasStepContent && /*#__PURE__*/_react.default.createElement("div", {
    className: "stepContentWrapper"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "stepContent"
  }, /*#__PURE__*/_react.default.createElement(_step_content.StepContent, {
    autoCheckIfStepCompleted: isExpandedStep ? autoCheckIfStepCompleted : undefined,
    cardId: cardId,
    indicesExist: indicesExist,
    sectionId: sectionId,
    step: step,
    toggleTaskCompleteStatus: toggleTaskCompleteStatus
  }))));
};
const CardStep = exports.CardStep = /*#__PURE__*/_react.default.memo(CardStepComponent);