"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autoCheckPrebuildRuleStepCompleted = exports.autoCheckAddIntegrationsStepCompleted = void 0;
var _apis = require("../apis");
var _rule_fields = require("../../../../../../common/detection_engine/rule_management/rule_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const autoCheckPrebuildRuleStepCompleted = async ({
  abortSignal,
  kibanaServicesHttp,
  onError
}) => {
  // Check if there are any rules installed and enabled
  try {
    const data = await (0, _apis.fetchRuleManagementFilters)({
      http: kibanaServicesHttp,
      signal: abortSignal.signal,
      query: {
        page: 1,
        per_page: 20,
        sort_field: 'enabled',
        sort_order: 'desc',
        filter: `${_rule_fields.ENABLED_FIELD}: true`
      }
    });
    return (data === null || data === void 0 ? void 0 : data.total) > 0;
  } catch (e) {
    if (!abortSignal.signal.aborted) {
      onError === null || onError === void 0 ? void 0 : onError(e);
    }
    return false;
  }
};
exports.autoCheckPrebuildRuleStepCompleted = autoCheckPrebuildRuleStepCompleted;
const autoCheckAddIntegrationsStepCompleted = async ({
  indicesExist
}) => Promise.resolve(indicesExist);
exports.autoCheckAddIntegrationsStepCompleted = autoCheckAddIntegrationsStepCompleted;