"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Video = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _constants = require("../../../../empty_prompt/constants");
var _step_context = require("../../context/step_context");
var _translations = require("../../translations");
var _types = require("../../types");
var _content_wrapper = require("./content_wrapper");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VIDEO_CONTENT_HEIGHT = 320;
const VideoComponent = () => {
  const {
    toggleTaskCompleteStatus,
    finishedSteps
  } = (0, _step_context.useStepContext)();
  const ref = _react2.default.useRef(null);
  const [isVideoPlaying, setIsVideoPlaying] = _react2.default.useState(false);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const cardId = _types.QuickStartSectionCardsId.watchTheOverviewVideo;
  const isFinishedStep = (0, _react2.useMemo)(() => {
    var _finishedSteps$cardId;
    return (_finishedSteps$cardId = finishedSteps[cardId]) === null || _finishedSteps$cardId === void 0 ? void 0 : _finishedSteps$cardId.has(_types.OverviewSteps.getToKnowElasticSecurity);
  }, [finishedSteps, cardId]);
  const onVideoClicked = (0, _react2.useCallback)(() => {
    toggleTaskCompleteStatus({
      stepId: _types.OverviewSteps.getToKnowElasticSecurity,
      cardId: _types.QuickStartSectionCardsId.watchTheOverviewVideo,
      sectionId: _types.SectionId.quickStart,
      undo: false,
      trigger: 'click'
    });
    setIsVideoPlaying(true);
  }, [toggleTaskCompleteStatus]);
  return /*#__PURE__*/_react2.default.createElement(_content_wrapper.ContentWrapper, null, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
          height: ${VIDEO_CONTENT_HEIGHT}px;
        `
  }, !isVideoPlaying && !isFinishedStep && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
              background-color: ${euiTheme.colors.fullShade};
              height: 100%;
              width: 100%;
              position: absolute;
              z-index: 1;
              cursor: pointer;
            `,
    gutterSize: "none",
    justifyContent: "center",
    alignItems: "center",
    onClick: onVideoClicked
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "playFilled",
    size: "xxl",
    color: euiTheme.colors.emptyShade
  }))), (isVideoPlaying || isFinishedStep) && /*#__PURE__*/_react2.default.createElement("iframe", {
    ref: ref,
    allowFullScreen: true,
    className: "vidyard_iframe",
    frameBorder: "0",
    height: "100%",
    width: "100%",
    referrerPolicy: "no-referrer",
    sandbox: "allow-scripts allow-same-origin",
    scrolling: "no",
    allow: isVideoPlaying ? 'autoplay;' : undefined,
    src: `${_constants.VIDEO_SOURCE}${isVideoPlaying ? '?autoplay=1' : ''}`,
    title: _translations.WATCH_VIDEO_BUTTON_TITLE
  })));
};
const Video = exports.Video = /*#__PURE__*/_react2.default.memo(VideoComponent);