"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentWrapper = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
var _step_content = require("../../styles/step_content.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContentWrapperComponent = ({
  children,
  shadow = true
}) => {
  const {
    getRightContentStyles
  } = (0, _step_content.useStepContentStyles)();
  const rightContentStyles = getRightContentStyles({
    shadow
  });
  const rightPanelContentClassNames = (0, _classnames.default)('right-panel-content', rightContentStyles);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: rightPanelContentClassNames
  }, children);
};
const ContentWrapper = exports.ContentWrapper = /*#__PURE__*/_react.default.memo(ContentWrapperComponent);