"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUCCESSFULLY_IMPORTED_EXCEPTIONS = exports.SUCCESSFULLY_IMPORTED_CONNECTORS = exports.OVERWRITE_EXCEPTIONS_LABEL = exports.OVERWRITE_ACTION_CONNECTORS_LABEL = exports.IMPORT_FAILED = exports.IMPORT_CONNECTORS_FAILED = exports.CANCEL_BUTTON = exports.ACTION_CONNECTORS_WARNING_TITLE = exports.ACTION_CONNECTORS_WARNING_BUTTON = exports.ACTION_CONNECTORS_ADDITIONAL_PRIVILEGES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CANCEL_BUTTON = exports.CANCEL_BUTTON = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.cancelTitle', {
  defaultMessage: 'Cancel'
});
const OVERWRITE_EXCEPTIONS_LABEL = exports.OVERWRITE_EXCEPTIONS_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.overwriteExceptionLabel', {
  defaultMessage: 'Overwrite existing exception lists with conflicting "list_id"'
});
const OVERWRITE_ACTION_CONNECTORS_LABEL = exports.OVERWRITE_ACTION_CONNECTORS_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.overwriteActionConnectorsLabel', {
  defaultMessage: 'Overwrite existing connectors with conflicting action "id"'
});
const SUCCESSFULLY_IMPORTED_EXCEPTIONS = totalExceptions => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.exceptionsSuccessLabel', {
  values: {
    totalExceptions
  },
  defaultMessage: 'Successfully imported {totalExceptions} {totalExceptions, plural, =1 {exception} other {exceptions}}.'
});
exports.SUCCESSFULLY_IMPORTED_EXCEPTIONS = SUCCESSFULLY_IMPORTED_EXCEPTIONS;
const SUCCESSFULLY_IMPORTED_CONNECTORS = totalConnectors => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.connectorsSuccessLabel', {
  values: {
    totalConnectors
  },
  defaultMessage: 'Successfully imported {totalConnectors} {totalConnectors, plural, =1 {connector} other {connectors}}.'
});
exports.SUCCESSFULLY_IMPORTED_CONNECTORS = SUCCESSFULLY_IMPORTED_CONNECTORS;
const IMPORT_FAILED = totalExceptions => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.importExceptionsFailedLabel', {
  values: {
    totalExceptions
  },
  defaultMessage: 'Failed to import {totalExceptions} {totalExceptions, plural, =1 {exception} other {exceptions}}'
});
exports.IMPORT_FAILED = IMPORT_FAILED;
const IMPORT_CONNECTORS_FAILED = totalConnectors => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.importConnectorsFailedLabel', {
  values: {
    totalConnectors
  },
  defaultMessage: 'Failed to import {totalConnectors} {totalConnectors, plural, =1 {connector} other {connectors}}'
});
exports.IMPORT_CONNECTORS_FAILED = IMPORT_CONNECTORS_FAILED;
const ACTION_CONNECTORS_WARNING_TITLE = totalConnectors => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.actionConnectorsWarningTitle', {
  values: {
    totalConnectors
  },
  defaultMessage: '{totalConnectors} {totalConnectors, plural, =1 {connector} other {connectors}} imported'
});
exports.ACTION_CONNECTORS_WARNING_TITLE = ACTION_CONNECTORS_WARNING_TITLE;
const ACTION_CONNECTORS_WARNING_BUTTON = exports.ACTION_CONNECTORS_WARNING_BUTTON = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.actionConnectorsWarningButton', {
  defaultMessage: 'Go to connectors'
});
const ACTION_CONNECTORS_ADDITIONAL_PRIVILEGES = exports.ACTION_CONNECTORS_ADDITIONAL_PRIVILEGES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.actionConnectorsAdditionalPrivilegesError', {
  defaultMessage: 'You need additional privileges to import rules with actions.'
});