"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHoverActionItems = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _reactRedux = require("react-redux");
var _helpers = require("../../../helpers");
var _kibana = require("../../lib/kibana");
var _helpers2 = require("../drag_and_drop/helpers");
var _timeline = require("../../../../common/types/timeline");
var _show_top_n = require("./actions/show_top_n");
var _actions = require("../../../timelines/store/actions");
var _use_data_view_id = require("../../hooks/use_data_view_id");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHoverActionItems = ({
  dataProvider,
  dataType,
  defaultFocusedButtonRef,
  draggableId,
  enableOverflowButton,
  field,
  fieldType,
  isAggregatable,
  handleHoverActionClicked,
  hideFilters,
  hideTopN,
  hideAddToTimeline,
  isCaseView,
  isObjectArray,
  isOverflowPopoverOpen,
  itemsToShow = 2,
  onFilterAdded,
  onOverflowButtonClick,
  ownFocus,
  showTopN,
  stKeyboardEvent,
  scopeId,
  toggleColumn,
  toggleTopN,
  values
}) => {
  const kibana = (0, _kibana.useKibana)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    timelines,
    timelineFilterManager
  } = kibana.services;
  const dataViewId = (0, _use_data_view_id.useDataViewId)((0, _helpers.getSourcererScopeId)(scopeId !== null && scopeId !== void 0 ? scopeId : ''));

  // Common actions used by the alert table and alert flyout
  const {
    getAddToTimelineButton,
    getColumnToggleButton,
    getCopyButton,
    getFilterForValueButton,
    getFilterOutValueButton,
    getOverflowButton
  } = timelines.getHoverActions();
  const filterManager = (0, _react.useMemo)(() => {
    return (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? timelineFilterManager : kibana.services.data.query.filterManager;
  }, [scopeId, timelineFilterManager, kibana.services.data.query.filterManager]);

  /*
   *   Add to Timeline button, adds data to dataprovider but does not persists the Timeline
   *   to the server because of following reasons.
   *
   *   1. Add to Timeline button performs actions in `timelines` plugin
   *   2. `timelines` plugin does not have information on how to create/update the timelines in the server
   *       as it is owned by Security Solution
   * */
  const OnAddToTimeline = (0, _react.useCallback)(() => {
    if (!dataProvider || (0, _lodash.isEmpty)(dataProvider)) return;
    dispatch((0, _actions.addProvider)({
      id: _timeline.TimelineId.active,
      providers: dataProvider instanceof Array ? dataProvider : [dataProvider]
    }));
  }, [dataProvider, dispatch]);
  const onAddToTimelineClicked = (0, _react.useCallback)(() => {
    if (handleHoverActionClicked) handleHoverActionClicked();
    OnAddToTimeline();
  }, [handleHoverActionClicked, OnAddToTimeline]);
  const showFilters = (0, _react.useMemo)(() => {
    if (hideFilters) return false;
    /*
     * In the case of `DisableOverflowButton`, we show filters only when topN is NOT opened. As after topN button is clicked, the chart panel replace current hover actions in the hover actions' popover, so we have to hide all the actions.
     * in the case of `EnableOverflowButton`, we only need to hide all the items in the overflow popover as the chart's panel opens in the overflow popover, so non-overflowed actions are not affected.
     */
    return values != null && (enableOverflowButton || !showTopN && !enableOverflowButton) && !isCaseView;
  }, [enableOverflowButton, hideFilters, isCaseView, showTopN, values]);
  const shouldDisableColumnToggle = isObjectArray && field !== 'geo_point' || isCaseView;
  const showTopNBtn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_show_top_n.ShowTopNButton, {
    Component: enableOverflowButton ? _eui.EuiContextMenuItem : undefined,
    "data-test-subj": "hover-actions-show-top-n",
    enablePopOver: !enableOverflowButton && isCaseView,
    field: field,
    key: "hover-actions-show-top-n",
    onClick: toggleTopN,
    onFilterAdded: onFilterAdded,
    ownFocus: ownFocus,
    showTopN: showTopN,
    showTooltip: enableOverflowButton ? false : true,
    scopeId: scopeId,
    value: values
  }), [enableOverflowButton, isCaseView, field, toggleTopN, onFilterAdded, ownFocus, showTopN, scopeId, values]);
  const allItems = (0, _react.useMemo)(() => [showFilters ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "hover-actions-filter-for",
    key: "hover-actions-filter-for"
  }, getFilterForValueButton({
    defaultFocusedButtonRef,
    field,
    filterManager,
    keyboardEvent: stKeyboardEvent,
    onClick: handleHoverActionClicked,
    onFilterAdded,
    ownFocus,
    showTooltip: enableOverflowButton ? false : true,
    value: values,
    dataViewId
  })) : null, showFilters ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "hover-actions-filter-out",
    key: "hover-actions-filter-out"
  }, getFilterOutValueButton({
    field,
    filterManager,
    keyboardEvent: stKeyboardEvent,
    onFilterAdded,
    ownFocus,
    onClick: handleHoverActionClicked,
    showTooltip: enableOverflowButton ? false : true,
    value: values,
    dataViewId
  })) : null, toggleColumn && !shouldDisableColumnToggle ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "hover-actions-toggle-column",
    key: "hover-actions-toggle-column"
  }, getColumnToggleButton({
    Component: enableOverflowButton ? _eui.EuiContextMenuItem : undefined,
    field,
    isDisabled: isObjectArray && dataType !== 'geo_point',
    isObjectArray,
    keyboardEvent: stKeyboardEvent,
    ownFocus,
    onClick: handleHoverActionClicked,
    showTooltip: enableOverflowButton ? false : true,
    toggleColumn,
    value: values
  })) : null, values != null && (draggableId != null || !(0, _lodash.isEmpty)(dataProvider)) && !hideAddToTimeline ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "hover-actions-add-timeline",
    key: "hover-actions-add-timeline"
  }, getAddToTimelineButton({
    Component: enableOverflowButton ? _eui.EuiContextMenuItem : undefined,
    dataProvider,
    draggableId,
    field,
    keyboardEvent: stKeyboardEvent,
    ownFocus,
    onClick: onAddToTimelineClicked,
    showTooltip: enableOverflowButton ? false : true,
    value: values
  })) : null, (0, _helpers2.allowTopN)({
    fieldType,
    isAggregatable,
    fieldName: field,
    hideTopN
  }) ? showTopNBtn : null, field != null ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "hover-actions-copy-button",
    key: "hover-actions-copy-button"
  }, getCopyButton({
    Component: enableOverflowButton ? _eui.EuiContextMenuItem : undefined,
    field,
    isHoverAction: true,
    keyboardEvent: stKeyboardEvent,
    ownFocus,
    onClick: handleHoverActionClicked,
    showTooltip: enableOverflowButton ? false : true,
    value: values
  })) : null].filter(item => {
    return item != null;
  }), [dataProvider, dataType, defaultFocusedButtonRef, draggableId, enableOverflowButton, field, fieldType, isAggregatable, filterManager, getAddToTimelineButton, getColumnToggleButton, getCopyButton, getFilterForValueButton, getFilterOutValueButton, handleHoverActionClicked, onAddToTimelineClicked, hideAddToTimeline, hideTopN, isObjectArray, onFilterAdded, ownFocus, shouldDisableColumnToggle, showFilters, showTopNBtn, stKeyboardEvent, toggleColumn, values, dataViewId]);
  const overflowActionItems = (0, _react.useMemo)(() => [...allItems.slice(0, itemsToShow), ...(enableOverflowButton && itemsToShow > 0 && itemsToShow < allItems.length ? [getOverflowButton({
    closePopOver: handleHoverActionClicked,
    field,
    keyboardEvent: stKeyboardEvent,
    ownFocus,
    onClick: onOverflowButtonClick,
    showTooltip: enableOverflowButton ? false : true,
    value: values,
    items: showTopN ? [showTopNBtn] : allItems.slice(itemsToShow),
    isOverflowPopoverOpen: !!isOverflowPopoverOpen
  })] : [])].filter(item => {
    return item != null;
  }), [allItems, enableOverflowButton, field, getOverflowButton, handleHoverActionClicked, isOverflowPopoverOpen, itemsToShow, onOverflowButtonClick, showTopNBtn, ownFocus, showTopN, stKeyboardEvent, values]);
  const allActionItems = (0, _react.useMemo)(() => showTopN && !enableOverflowButton && !isCaseView ? [showTopNBtn] : allItems, [showTopN, enableOverflowButton, isCaseView, showTopNBtn, allItems]);
  return {
    overflowActionItems,
    allActionItems
  };
};
exports.useHoverActionItems = useHoverActionItems;