"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _types = require("../../../../common/types");
var _column_headers = require("../../../timelines/components/timeline/body/column_headers");
var _helpers = require("../../../helpers");
var _helpers2 = require("../../../timelines/components/timeline/body/column_headers/helpers");
var _store = require("../../../timelines/store");
var _use_selector = require("../../hooks/use_selector");
var _use_full_screen = require("../../containers/use_full_screen");
var _kibana = require("../../lib/kibana");
var _ = require(".");
var _styles = require("../../../timelines/components/timeline/styles");
var _row_renderers_browser = require("../../../timelines/components/row_renderers_browser");
var _translations = require("../exit_full_screen/translations");
var _events_select = require("../../../timelines/components/timeline/body/column_headers/events_select");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SortingColumnsContainer = _styledComponents.default.div`
  button {
    color: ${({
  theme
}) => theme.eui.euiColorPrimary};
  }

  .euiPopover .euiButtonEmpty {
    padding: 0;

    .euiButtonEmpty__text {
      display: none;
    }
  }
`;
const FieldBrowserContainer = _styledComponents.default.div`
  .euiToolTipAnchor {
    .euiButtonContent {
      padding: ${({
  theme
}) => `0 ${theme.eui.euiSizeXS}`};
    }
    button {
      color: ${({
  theme
}) => theme.eui.euiColorPrimary};
    }
    .euiButtonContent__icon {
      width: 16px;
      height: 16px;
    }
    .euiButtonEmpty__text {
      display: none;
    }
  }
`;
const ActionsContainer = _styledComponents.default.div`
  align-items: center;
  display: flex;
`;

// Defined statically to reduce rerenders
const emptySchema = {};
const emptySchemaDetectors = [];
const HeaderActionsComponent = /*#__PURE__*/(0, _react.memo)(({
  width,
  browserFields,
  columnHeaders,
  isEventViewer = false,
  isSelectAllChecked,
  onSelectAll,
  showEventsSelect,
  showSelectAllCheckbox,
  sort,
  tabType,
  timelineId,
  fieldBrowserOptions
}) => {
  const {
    triggersActionsUi
  } = (0, _kibana.useKibana)().services;
  const {
    globalFullScreen,
    setGlobalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const {
    timelineFullScreen,
    setTimelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const getManageTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    defaultColumns
  } = (0, _use_selector.useDeepEqualSelector)(state => getManageTimeline(state, timelineId));
  const toggleFullScreen = (0, _react.useCallback)(() => {
    if (timelineId === _types.TimelineId.active) {
      setTimelineFullScreen(!timelineFullScreen);
    } else {
      setGlobalFullScreen(!globalFullScreen);
    }
  }, [timelineId, setTimelineFullScreen, timelineFullScreen, setGlobalFullScreen, globalFullScreen]);
  const fullScreen = (0, _react.useMemo)(() => (0, _column_headers.isFullScreen)({
    globalFullScreen,
    isActiveTimelines: (0, _helpers.isActiveTimeline)(timelineId),
    timelineFullScreen
  }), [globalFullScreen, timelineFullScreen, timelineId]);
  const handleSelectAllChange = (0, _react.useCallback)(event => {
    onSelectAll({
      isSelected: event.currentTarget.checked
    });
  }, [onSelectAll]);
  const onSortColumns = (0, _react.useCallback)(cols => dispatch(_store.timelineActions.updateSort({
    id: timelineId,
    sort: cols.map(({
      id,
      direction
    }) => {
      var _columnHeader$type, _columnHeader$esTypes;
      const columnHeader = columnHeaders.find(ch => ch.id === id);
      const columnType = (_columnHeader$type = columnHeader === null || columnHeader === void 0 ? void 0 : columnHeader.type) !== null && _columnHeader$type !== void 0 ? _columnHeader$type : '';
      const esTypes = (_columnHeader$esTypes = columnHeader === null || columnHeader === void 0 ? void 0 : columnHeader.esTypes) !== null && _columnHeader$esTypes !== void 0 ? _columnHeader$esTypes : [];
      return {
        columnId: id,
        columnType,
        esTypes,
        sortDirection: direction
      };
    })
  })), [columnHeaders, dispatch, timelineId]);
  const sortedColumns = (0, _react.useMemo)(() => {
    var _sort$map;
    return {
      onSort: onSortColumns,
      columns: (_sort$map = sort === null || sort === void 0 ? void 0 : sort.map(({
        columnId,
        sortDirection
      }) => ({
        id: columnId,
        direction: sortDirection
      }))) !== null && _sort$map !== void 0 ? _sort$map : []
    };
  }, [onSortColumns, sort]);
  const displayValues = (0, _react.useMemo)(() => {
    var _columnHeaders$reduce;
    return (_columnHeaders$reduce = columnHeaders === null || columnHeaders === void 0 ? void 0 : columnHeaders.reduce((acc, ch) => {
      var _ch$displayAsText;
      return {
        ...acc,
        [ch.id]: (_ch$displayAsText = ch.displayAsText) !== null && _ch$displayAsText !== void 0 ? _ch$displayAsText : ch.id
      };
    }, {})) !== null && _columnHeaders$reduce !== void 0 ? _columnHeaders$reduce : {};
  }, [columnHeaders]);
  const myColumns = (0, _react.useMemo)(() => {
    var _columnHeaders$map;
    return (_columnHeaders$map = columnHeaders === null || columnHeaders === void 0 ? void 0 : columnHeaders.map(({
      aggregatable,
      displayAsText,
      id,
      type
    }) => ({
      id,
      isSortable: aggregatable,
      displayAsText,
      schema: type
    }))) !== null && _columnHeaders$map !== void 0 ? _columnHeaders$map : [];
  }, [columnHeaders]);
  const onResetColumns = (0, _react.useCallback)(() => {
    dispatch(_store.timelineActions.updateColumns({
      id: timelineId,
      columns: defaultColumns
    }));
  }, [defaultColumns, dispatch, timelineId]);
  const onToggleColumn = (0, _react.useCallback)(columnId => {
    if (columnHeaders.some(({
      id
    }) => id === columnId)) {
      dispatch(_store.timelineActions.removeColumn({
        columnId,
        id: timelineId
      }));
    } else {
      dispatch(_store.timelineActions.upsertColumn({
        column: (0, _helpers2.getColumnHeader)(columnId, defaultColumns),
        id: timelineId,
        index: 1
      }));
    }
  }, [columnHeaders, dispatch, timelineId, defaultColumns]);
  const ColumnSorting = (0, _eui.useDataGridColumnSorting)({
    columns: myColumns,
    sorting: sortedColumns,
    schema: emptySchema,
    schemaDetectors: emptySchemaDetectors,
    displayValues
  });
  return /*#__PURE__*/_react.default.createElement(ActionsContainer, null, showSelectAllCheckbox && /*#__PURE__*/_react.default.createElement(_styles.EventsTh, {
    role: "checkbox"
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsThContent, {
    textAlign: "center",
    width: _.DEFAULT_ACTION_BUTTON_WIDTH
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "select-all-events",
    id: 'select-all-events',
    checked: isSelectAllChecked,
    onChange: handleSelectAllChange
  }))), /*#__PURE__*/_react.default.createElement(_styles.EventsTh, {
    role: "button"
  }, /*#__PURE__*/_react.default.createElement(FieldBrowserContainer, null, triggersActionsUi.getFieldBrowser({
    browserFields,
    columnIds: columnHeaders.map(({
      id
    }) => id),
    onResetColumns,
    onToggleColumn,
    options: fieldBrowserOptions
  }))), /*#__PURE__*/_react.default.createElement(_styles.EventsTh, {
    role: "button"
  }, /*#__PURE__*/_react.default.createElement(_row_renderers_browser.StatefulRowRenderersBrowser, {
    "data-test-subj": "row-renderers-browser",
    timelineId: timelineId
  })), /*#__PURE__*/_react.default.createElement(_styles.EventsTh, {
    role: "button"
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsThContent, {
    textAlign: "center",
    width: _.DEFAULT_ACTION_BUTTON_WIDTH
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: fullScreen ? _translations.EXIT_FULL_SCREEN : i18n.FULL_SCREEN
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": (0, _column_headers.isFullScreen)({
      globalFullScreen,
      isActiveTimelines: (0, _helpers.isActiveTimeline)(timelineId),
      timelineFullScreen
    }) ? _translations.EXIT_FULL_SCREEN : i18n.FULL_SCREEN,
    display: fullScreen ? 'fill' : 'empty',
    color: "primary",
    "data-test-subj":
    // a full screen button gets created for timeline and for the host page
    // this sets the data-test-subj for each case so that tests can differentiate between them
    (0, _helpers.isActiveTimeline)(timelineId) ? 'full-screen-active' : 'full-screen',
    iconType: "fullScreen",
    onClick: toggleFullScreen
  })))), tabType !== _types.TimelineTabs.eql && /*#__PURE__*/_react.default.createElement(_styles.EventsTh, {
    role: "button",
    "data-test-subj": "timeline-sorting-fields"
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsThContent, {
    textAlign: "center",
    width: _.DEFAULT_ACTION_BUTTON_WIDTH
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.SORT_FIELDS
  }, /*#__PURE__*/_react.default.createElement(SortingColumnsContainer, null, ColumnSorting)))), showEventsSelect && /*#__PURE__*/_react.default.createElement(_styles.EventsTh, {
    role: "button"
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsThContent, {
    textAlign: "center",
    width: _.DEFAULT_ACTION_BUTTON_WIDTH
  }, /*#__PURE__*/_react.default.createElement(_events_select.EventsSelect, {
    checkState: "unchecked",
    timelineId: timelineId
  }))));
});
HeaderActionsComponent.displayName = 'HeaderActionsComponent';
const HeaderActions = exports.HeaderActions = /*#__PURE__*/_react.default.memo(HeaderActionsComponent);