"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tableHasFocus = exports.resolverIsShowing = exports.isViewSelection = exports.isSelectableView = exports.getDefaultViewSelection = exports.getCombinedFilterQuery = exports.elementOrChildrenHasFocus = exports.EVENTS_COUNT_BUTTON_CLASS_NAME = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _kuery = require("../../lib/kuery");
var _styles = require("./styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCombinedFilterQuery = ({
  from,
  to,
  filters,
  ...combineQueriesParams
}) => {
  const combinedQueries = (0, _kuery.combineQueries)({
    ...combineQueriesParams,
    filters: [...filters, (0, _kuery.buildTimeRangeFilter)(from, to)]
  });
  return combinedQueries ? combinedQueries.filterQuery : undefined;
};
exports.getCombinedFilterQuery = getCombinedFilterQuery;
const resolverIsShowing = graphEventId => graphEventId != null && graphEventId !== '';
exports.resolverIsShowing = resolverIsShowing;
const EVENTS_COUNT_BUTTON_CLASS_NAME = exports.EVENTS_COUNT_BUTTON_CLASS_NAME = 'local-events-count-button';

/** Returns `true` when the element, or one of it's children has focus */
const elementOrChildrenHasFocus = element => element === document.activeElement || (element === null || element === void 0 ? void 0 : element.querySelector(':focus-within')) != null;

/** Returns true if the events table has focus */
exports.elementOrChildrenHasFocus = elementOrChildrenHasFocus;
const tableHasFocus = containerElement => elementOrChildrenHasFocus(containerElement === null || containerElement === void 0 ? void 0 : containerElement.querySelector(`.${_styles.EVENTS_TABLE_CLASS_NAME}`));
exports.tableHasFocus = tableHasFocus;
const isSelectableView = tableId => tableId === _securitysolutionDataTable.TableId.alertsOnAlertsPage || tableId === _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage;
exports.isSelectableView = isSelectableView;
const isViewSelection = value => value === 'gridView' || value === 'eventRenderedView';

/** always returns a valid default `ViewSelection` */
exports.isViewSelection = isViewSelection;
const getDefaultViewSelection = ({
  tableId,
  value
}) => {
  const defaultViewSelection = 'gridView';
  if (!isSelectableView(tableId)) {
    return defaultViewSelection;
  } else {
    return isViewSelection(value) ? value : defaultViewSelection;
  }
};
exports.getDefaultViewSelection = getDefaultViewSelection;