"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SHOW_EXTERNAL_ALERTS = exports.SHOWING = exports.EXTERNAL_ALERTS_UNIT = exports.EVENTS_UNIT = exports.EVENTS_GRAPH_TITLE = exports.ERROR_FETCHING_EVENTS_DATA = exports.ERROR_FETCHING_ALERTS_DATA = exports.ALERTS_GRAPH_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EXTERNAL_ALERTS_UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.eventsTab.externalAlertsUnit', {
  values: {
    totalCount
  },
  defaultMessage: `external {totalCount, plural, =1 {alert} other {alerts}}`
});
exports.EXTERNAL_ALERTS_UNIT = EXTERNAL_ALERTS_UNIT;
const EVENTS_UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.hosts.navigaton.eventsUnit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {event} other {events}}`
});
exports.EVENTS_UNIT = EVENTS_UNIT;
const SHOWING = exports.SHOWING = _i18n.i18n.translate('xpack.securitySolution.eventsTab.showing', {
  defaultMessage: 'Showing'
});
const ALERTS_GRAPH_TITLE = exports.ALERTS_GRAPH_TITLE = _i18n.i18n.translate('xpack.securitySolution.eventsTab.alertsGraphTitle', {
  defaultMessage: 'External alert trend'
});
const ERROR_FETCHING_ALERTS_DATA = exports.ERROR_FETCHING_ALERTS_DATA = _i18n.i18n.translate('xpack.securitySolution.eventsTab.errorFetchingAlertsData', {
  defaultMessage: 'Failed to query alerts data'
});
const ERROR_FETCHING_EVENTS_DATA = exports.ERROR_FETCHING_EVENTS_DATA = _i18n.i18n.translate('xpack.securitySolution.eventsTab.errorFetchingEventsData', {
  defaultMessage: 'Failed to query events data'
});
const SHOW_EXTERNAL_ALERTS = exports.SHOW_EXTERNAL_ALERTS = _i18n.i18n.translate('xpack.securitySolution.eventsTab.showExternalAlerts', {
  defaultMessage: 'Show only external alerts'
});
const EVENTS_GRAPH_TITLE = exports.EVENTS_GRAPH_TITLE = _i18n.i18n.translate('xpack.securitySolution.eventsGraphTitle', {
  defaultMessage: 'Events'
});