"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_COLUMN = exports.VIEW_ALL_FIELDS = exports.VALUE = exports.TIMELINE_VIEW = exports.THREAT_INTEL = exports.TABLE = exports.SUMMARY_VIEW = exports.RULE_TYPE = exports.RESPONSE_ACTIONS_VIEW = exports.QUARANTINED_FILE_PATH = exports.PLACEHOLDER = exports.OVERVIEW = exports.OSQUERY_VIEW = exports.NESTED_COLUMN = exports.MULTI_FIELD_TOOLTIP = exports.MULTI_FIELD_BADGE = exports.JSON_VIEW = exports.INVESTIGATION_GUIDE = exports.HIGHLIGHTED_FIELDS_VALUE = exports.HIGHLIGHTED_FIELDS_FIELD = exports.HIGHLIGHTED_FIELDS_ALERT_PREVALENCE_TOOLTIP = exports.HIGHLIGHTED_FIELDS_ALERT_PREVALENCE = exports.HIGHLIGHTED_FIELDS = exports.FIELD = exports.EVENT_SUMMARY_VIEW_CONTEXT_TOOLTIP = exports.EVENT_SUMMARY_CONVERSATION_ID = exports.EVENT_SUMMARY_CONTEXT_DESCRIPTION = exports.ENDPOINT_COMMANDS = exports.DESCRIPTION = exports.ALERT_SUMMARY_VIEW_CONTEXT_TOOLTIP = exports.ALERT_SUMMARY_CONVERSATION_ID = exports.ALERT_SUMMARY_CONTEXT_DESCRIPTION = exports.ALERT_REASON = exports.AGENT_STATUS = exports.ACTIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const THREAT_INTEL = exports.THREAT_INTEL = _i18n.i18n.translate('xpack.securitySolution.alertDetails.threatIntel', {
  defaultMessage: 'Threat Intel'
});
const INVESTIGATION_GUIDE = exports.INVESTIGATION_GUIDE = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.investigationGuide', {
  defaultMessage: 'Investigation guide'
});
const OVERVIEW = exports.OVERVIEW = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview', {
  defaultMessage: 'Overview'
});
const HIGHLIGHTED_FIELDS = exports.HIGHLIGHTED_FIELDS = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.highlightedFields', {
  defaultMessage: 'Highlighted fields'
});
const HIGHLIGHTED_FIELDS_FIELD = exports.HIGHLIGHTED_FIELDS_FIELD = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.highlightedFields.field', {
  defaultMessage: 'Field'
});
const HIGHLIGHTED_FIELDS_VALUE = exports.HIGHLIGHTED_FIELDS_VALUE = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.highlightedFields.value', {
  defaultMessage: 'Value'
});
const HIGHLIGHTED_FIELDS_ALERT_PREVALENCE = exports.HIGHLIGHTED_FIELDS_ALERT_PREVALENCE = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.highlightedFields.alertPrevalence', {
  defaultMessage: 'Alert prevalence'
});
const HIGHLIGHTED_FIELDS_ALERT_PREVALENCE_TOOLTIP = exports.HIGHLIGHTED_FIELDS_ALERT_PREVALENCE_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.highlightedFields.alertPrevalenceTooltip', {
  defaultMessage: 'The total count of alerts with the same value within the currently selected timerange. This value is not affected by additional filters.'
});
const TABLE = exports.TABLE = _i18n.i18n.translate('xpack.securitySolution.eventDetails.table', {
  defaultMessage: 'Table'
});
const JSON_VIEW = exports.JSON_VIEW = _i18n.i18n.translate('xpack.securitySolution.eventDetails.jsonView', {
  defaultMessage: 'JSON'
});
const OSQUERY_VIEW = exports.OSQUERY_VIEW = _i18n.i18n.translate('xpack.securitySolution.eventDetails.osqueryView', {
  defaultMessage: 'Osquery Results'
});
const RESPONSE_ACTIONS_VIEW = exports.RESPONSE_ACTIONS_VIEW = _i18n.i18n.translate('xpack.securitySolution.eventDetails.responseActionsView', {
  defaultMessage: 'Response Results'
});
const FIELD = exports.FIELD = _i18n.i18n.translate('xpack.securitySolution.eventDetails.field', {
  defaultMessage: 'Field'
});
const VALUE = exports.VALUE = _i18n.i18n.translate('xpack.securitySolution.eventDetails.value', {
  defaultMessage: 'Value'
});
const DESCRIPTION = exports.DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.eventDetails.description', {
  defaultMessage: 'Description'
});
const PLACEHOLDER = exports.PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.eventDetails.filter.placeholder', {
  defaultMessage: 'Filter by Field, Value, or Description...'
});
const VIEW_COLUMN = field => _i18n.i18n.translate('xpack.securitySolution.eventDetails.viewColumnCheckboxAriaLabel', {
  values: {
    field
  },
  defaultMessage: 'View {field} column'
});
exports.VIEW_COLUMN = VIEW_COLUMN;
const NESTED_COLUMN = field => _i18n.i18n.translate('xpack.securitySolution.eventDetails.nestedColumnCheckboxAriaLabel', {
  values: {
    field
  },
  defaultMessage: 'The {field} field is an object, and is broken down into nested fields which can be added as column'
});
exports.NESTED_COLUMN = NESTED_COLUMN;
const AGENT_STATUS = exports.AGENT_STATUS = _i18n.i18n.translate('xpack.securitySolution.detections.alerts.agentStatus', {
  defaultMessage: 'Agent status'
});
const QUARANTINED_FILE_PATH = exports.QUARANTINED_FILE_PATH = _i18n.i18n.translate('xpack.securitySolution.detections.alerts.quarantinedFilePath', {
  defaultMessage: 'Quarantined file path'
});
const RULE_TYPE = exports.RULE_TYPE = _i18n.i18n.translate('xpack.securitySolution.detections.alerts.ruleType', {
  defaultMessage: 'Rule type'
});
const MULTI_FIELD_TOOLTIP = exports.MULTI_FIELD_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.eventDetails.multiFieldTooltipContent', {
  defaultMessage: 'Multi-fields can have multiple values per field'
});
const MULTI_FIELD_BADGE = exports.MULTI_FIELD_BADGE = _i18n.i18n.translate('xpack.securitySolution.eventDetails.multiFieldBadge', {
  defaultMessage: 'multi-field'
});
const ACTIONS = exports.ACTIONS = _i18n.i18n.translate('xpack.securitySolution.eventDetails.table.actions', {
  defaultMessage: 'Actions'
});
const ALERT_REASON = exports.ALERT_REASON = _i18n.i18n.translate('xpack.securitySolution.eventDetails.alertReason', {
  defaultMessage: 'Alert reason'
});
const VIEW_ALL_FIELDS = exports.VIEW_ALL_FIELDS = _i18n.i18n.translate('xpack.securitySolution.eventDetails.viewAllFields', {
  defaultMessage: 'View all fields in table'
});
const ENDPOINT_COMMANDS = exports.ENDPOINT_COMMANDS = Object.freeze({
  tried: command => _i18n.i18n.translate('xpack.securitySolution.eventDetails.responseActions.endpoint.tried', {
    values: {
      command
    },
    defaultMessage: 'tried to execute {command} command'
  }),
  executed: command => _i18n.i18n.translate('xpack.securitySolution.eventDetails.responseActions.endpoint.executed', {
    values: {
      command
    },
    defaultMessage: 'executed {command} command'
  }),
  pending: command => _i18n.i18n.translate('xpack.securitySolution.eventDetails.responseActions.endpoint.pending', {
    values: {
      command
    },
    defaultMessage: 'is executing {command} command'
  }),
  failed: command => _i18n.i18n.translate('xpack.securitySolution.eventDetails.responseActions.endpoint.failed', {
    values: {
      command
    },
    defaultMessage: 'failed to execute {command} command'
  })
});
const SUMMARY_VIEW = exports.SUMMARY_VIEW = _i18n.i18n.translate('xpack.securitySolution.eventDetails.summaryView', {
  defaultMessage: 'summary'
});
const TIMELINE_VIEW = exports.TIMELINE_VIEW = _i18n.i18n.translate('xpack.securitySolution.eventDetails.timelineView', {
  defaultMessage: 'Timeline'
});
const ALERT_SUMMARY_CONVERSATION_ID = exports.ALERT_SUMMARY_CONVERSATION_ID = _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.alertSummaryViewConversationId', {
  defaultMessage: 'Alert summary'
});
const ALERT_SUMMARY_CONTEXT_DESCRIPTION = view => _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.alertSummaryViewContextDescription', {
  defaultMessage: 'Alert (from {view})',
  values: {
    view
  }
});
exports.ALERT_SUMMARY_CONTEXT_DESCRIPTION = ALERT_SUMMARY_CONTEXT_DESCRIPTION;
const ALERT_SUMMARY_VIEW_CONTEXT_TOOLTIP = exports.ALERT_SUMMARY_VIEW_CONTEXT_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.alertSummaryViewContextTooltip', {
  defaultMessage: 'Add this alert as context'
});
const EVENT_SUMMARY_CONVERSATION_ID = exports.EVENT_SUMMARY_CONVERSATION_ID = _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.eventSummaryViewConversationId', {
  defaultMessage: 'Event summary'
});
const EVENT_SUMMARY_CONTEXT_DESCRIPTION = view => _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.eventSummaryViewContextDescription', {
  defaultMessage: 'Event (from {view})',
  values: {
    view
  }
});
exports.EVENT_SUMMARY_CONTEXT_DESCRIPTION = EVENT_SUMMARY_CONTEXT_DESCRIPTION;
const EVENT_SUMMARY_VIEW_CONTEXT_TOOLTIP = exports.EVENT_SUMMARY_VIEW_CONTEXT_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.eventSummaryViewContextTooltip', {
  defaultMessage: 'Add this event as context'
});