"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigateInTimelineButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _store = require("../../../store");
var _constants = require("../../../store/inputs/constants");
var _inputs = require("../../../store/inputs");
var _actions = require("../../../../timelines/store/actions");
var _actions2 = require("../../../store/actions");
var _model = require("../../../store/sourcerer/model");
var _timeline = require("../../../../../common/types/timeline");
var _timeline2 = require("../../../../../common/api/timeline");
var _use_create_timeline = require("../../../../timelines/hooks/use_create_timeline");
var _translations = require("../../../../detections/components/alerts_table/translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InvestigateInTimelineButton = ({
  asEmptyButton,
  children,
  dataProviders,
  filters,
  timeRange,
  keepDataView,
  iconType,
  ...rest
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const signalIndexName = (0, _reactRedux.useSelector)(_store.sourcererSelectors.signalIndexName);
  const defaultDataView = (0, _reactRedux.useSelector)(_store.sourcererSelectors.defaultDataView);
  const hasTemplateProviders = dataProviders && dataProviders.find(provider => provider.type === 'template');
  const clearTimeline = (0, _use_create_timeline.useCreateTimeline)({
    timelineId: _timeline.TimelineId.active,
    timelineType: hasTemplateProviders ? _timeline2.TimelineType.template : _timeline2.TimelineType.default
  });
  const configureAndOpenTimeline = (0, _react.useCallback)(async () => {
    if (dataProviders || filters) {
      // Reset the current timeline
      if (timeRange) {
        await clearTimeline({
          timeRange
        });
      } else {
        await clearTimeline();
      }
      if (dataProviders) {
        // Update the timeline's providers to match the current prevalence field query
        dispatch((0, _actions.updateProviders)({
          id: _timeline.TimelineId.active,
          providers: dataProviders
        }));
      }
      // Use filters if more than a certain amount of ids for dom performance.
      if (filters) {
        dispatch((0, _actions.setFilters)({
          id: _timeline.TimelineId.active,
          filters
        }));
      }
      // Only show detection alerts
      // (This is required so the timeline event count matches the prevalence count)
      if (!keepDataView) {
        dispatch(_actions2.sourcererActions.setSelectedDataView({
          id: _model.SourcererScopeName.timeline,
          selectedDataViewId: defaultDataView.id,
          selectedPatterns: [signalIndexName || '']
        }));
      }
      // Unlock the time range from the global time range
      dispatch(_inputs.inputsActions.removeLinkTo([_constants.InputsModelId.timeline, _constants.InputsModelId.global]));
    }
  }, [dataProviders, clearTimeline, dispatch, defaultDataView.id, signalIndexName, filters, timeRange, keepDataView]);
  return asEmptyButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _translations.ACTION_INVESTIGATE_IN_TIMELINE,
    onClick: configureAndOpenTimeline,
    flush: "right",
    size: "xs",
    iconType: iconType
  }, children) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "aria-label": _translations.ACTION_INVESTIGATE_IN_TIMELINE,
    onClick: configureAndOpenTimeline
  }, rest), children);
};
exports.InvestigateInTimelineButton = InvestigateInTimelineButton;
InvestigateInTimelineButton.displayName = 'InvestigateInTimelineButton';