"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldNameCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _reactField = require("@kbn/react-field");
var i18n = _interopRequireWildcard(require("../translations"));
var _helpers = require("../helpers");
var _get_field_type_name = require("./get_field_type_name");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldNameCell = exports.FieldNameCell = /*#__PURE__*/_react.default.memo(({
  data,
  field,
  fieldMapping,
  scripted
}) => {
  const typeName = (0, _get_field_type_name.getFieldTypeName)(data.type);
  // TODO: We don't have fieldMapping or isMultiField until kibana indexPatterns is implemented. Will default to field for now
  const displayName = fieldMapping && fieldMapping.displayName ? fieldMapping.displayName : field;
  const defaultTooltip = displayName !== field ? `${field} (${displayName})` : field;
  // TODO: Remove. This is what was used to show the plaintext fieldName vs the tooltip one
  // const showPlainTextName =
  //   (data.isObjectArray && data.type !== 'geo_point') || fieldFromBrowserField == null;
  const isMultiField = fieldMapping === null || fieldMapping === void 0 ? void 0 : fieldMapping.isSubtypeMulti();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eventFieldsTable__fieldIcon"
  }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
    "data-test-subj": "field-type-icon",
    type: data.type,
    label: typeName,
    scripted: scripted // TODO: Will get with kibana indexPatterns;
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "none",
    responsive: false,
    alignItems: "flexStart",
    "data-test-subj": "field-name-cell"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eventFieldsTable__fieldName eui-textBreakAll",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: !(0, _lodash.isEmpty)(data.description) ? `${data.description} ${(0, _helpers.getExampleText)(data.example)}` : defaultTooltip,
    delay: "long",
    anchorClassName: "eui-textBreakAll"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": "field-name"
  }, field))), isMultiField && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    delay: "long",
    content: i18n.MULTI_FIELD_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    title: "",
    className: "eventFieldsTable__multiFieldBadge",
    color: "default",
    "data-test-subj": `eventFieldsTableRow-${field}-multifieldBadge`
  }, i18n.MULTI_FIELD_BADGE))));
});
FieldNameCell.displayName = 'FieldNameCell';