"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = exports.NotGrowingFlexGroup = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _common = require("@kbn/kibana-react-plugin/common");
var _helpers = require("../helpers");
var _translations = require("../../../../detections/components/alerts_table/translations");
var _constants = require("../../../../timelines/components/timeline/body/renderers/constants");
var _formatted_field = require("../../../../timelines/components/timeline/body/renderers/formatted_field");
var _overview_card = require("./overview_card");
var _status_popover_button = require("./status_popover_button");
var _severity_badge = require("../../severity_badge");
var _utils = require("../../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NotGrowingFlexGroup = exports.NotGrowingFlexGroup = (0, _common.euiStyled)(_eui.EuiFlexGroup)`
  flex-grow: 0;
`;
const Overview = exports.Overview = /*#__PURE__*/_react.default.memo(({
  browserFields,
  contextId,
  data,
  eventId,
  handleOnEventClosed,
  scopeId,
  isReadOnly
}) => {
  const statusData = (0, _react.useMemo)(() => {
    const item = (0, _fp.find)({
      field: _constants.SIGNAL_STATUS_FIELD_NAME,
      category: 'kibana'
    }, data);
    return item && (0, _helpers.getEnrichedFieldInfo)({
      eventId,
      contextId,
      scopeId,
      browserFields,
      item
    });
  }, [browserFields, contextId, data, eventId, scopeId]);
  const severityData = (0, _react.useMemo)(() => {
    const item = (0, _fp.find)({
      field: 'kibana.alert.severity',
      category: 'kibana'
    }, data);
    return item && (0, _helpers.getEnrichedFieldInfo)({
      eventId,
      contextId,
      scopeId,
      browserFields,
      item
    });
  }, [browserFields, contextId, data, eventId, scopeId]);
  const riskScoreData = (0, _react.useMemo)(() => {
    const item = (0, _fp.find)({
      field: 'kibana.alert.risk_score',
      category: 'kibana'
    }, data);
    return item && (0, _helpers.getEnrichedFieldInfo)({
      eventId,
      contextId,
      scopeId,
      browserFields,
      item
    });
  }, [browserFields, contextId, data, eventId, scopeId]);
  const ruleNameData = (0, _react.useMemo)(() => {
    const item = (0, _fp.find)({
      field: _constants.SIGNAL_RULE_NAME_FIELD_NAME,
      category: 'kibana'
    }, data);
    const linkValueField = (0, _fp.find)({
      field: 'kibana.alert.rule.uuid',
      category: 'kibana'
    }, data);
    return item && (0, _helpers.getEnrichedFieldInfo)({
      eventId,
      contextId,
      scopeId,
      browserFields,
      item,
      linkValueField
    });
  }, [browserFields, contextId, data, eventId, scopeId]);
  const signalCard = hasData(statusData) && !isReadOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: "status"
  }, /*#__PURE__*/_react.default.createElement(_overview_card.OverviewCardWithActions, {
    title: _translations.SIGNAL_STATUS,
    enrichedFieldInfo: statusData,
    contextId: contextId
  }, /*#__PURE__*/_react.default.createElement(_status_popover_button.StatusPopoverButton, {
    eventId: eventId,
    contextId: contextId,
    enrichedFieldInfo: statusData,
    scopeId: scopeId,
    handleOnEventClosed: handleOnEventClosed
  }))) : null;
  const severityCard = hasData(severityData) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: "severity"
  }, !isReadOnly ? /*#__PURE__*/_react.default.createElement(_overview_card.OverviewCardWithActions, {
    title: _translations.ALERTS_HEADERS_SEVERITY,
    enrichedFieldInfo: severityData,
    contextId: contextId
  }, /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
    value: severityData.values[0]
  })) : /*#__PURE__*/_react.default.createElement(_overview_card.OverviewCard, {
    title: _translations.ALERTS_HEADERS_SEVERITY
  }, /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
    value: severityData.values[0]
  }))) : null;
  const riskScoreCard = hasData(riskScoreData) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: "riskScore"
  }, !isReadOnly ? /*#__PURE__*/_react.default.createElement(_overview_card.OverviewCardWithActions, {
    title: _translations.ALERTS_HEADERS_RISK_SCORE,
    enrichedFieldInfo: riskScoreData,
    contextId: contextId,
    dataTestSubj: "riskScore"
  }, riskScoreData.values[0]) : /*#__PURE__*/_react.default.createElement(_overview_card.OverviewCard, {
    title: _translations.ALERTS_HEADERS_RISK_SCORE
  }, riskScoreData.values[0])) : null;
  const ruleNameCard = hasData(ruleNameData) && !isReadOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: "ruleName"
  }, /*#__PURE__*/_react.default.createElement(_overview_card.OverviewCardWithActions, {
    title: _translations.ALERTS_HEADERS_RULE,
    enrichedFieldInfo: ruleNameData,
    contextId: contextId
  }, /*#__PURE__*/_react.default.createElement(_formatted_field.FormattedFieldValue, {
    contextId: contextId,
    eventId: eventId,
    value: ruleNameData.values[0],
    fieldName: ruleNameData.data.field,
    linkValue: ruleNameData.linkValue,
    fieldType: ruleNameData.data.type,
    fieldFormat: ruleNameData.data.format,
    isDraggable: false,
    truncate: false
  }))) : null;
  const {
    width,
    ref
  } = (0, _utils.useThrottledResizeObserver)();

  // 675px is the container width at which none of the cards, when hovered,
  // creates a visual overflow in a single row setup
  const showAsSingleRow = width === 0 || width && width >= 675;

  // Only render cards with content
  const cards = [signalCard, severityCard, riskScoreCard, ruleNameCard].filter(isNotNull);

  // If there is enough space, render a single row.
  // Otherwise, render two rows with each two cards.
  const content = showAsSingleRow ? /*#__PURE__*/_react.default.createElement(NotGrowingFlexGroup, {
    gutterSize: "s"
  }, cards) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _fp.chunk)(2, cards).map((elements, index, {
    length
  }) => {
    // Add a spacer between rows but not after the last row
    const addSpacer = index < length - 1;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: index
    }, /*#__PURE__*/_react.default.createElement(NotGrowingFlexGroup, {
      gutterSize: "s"
    }, elements), addSpacer && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }));
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: ref
  }, content);
});
function hasData(fieldInfo) {
  return !!fieldInfo && Array.isArray(fieldInfo.values);
}
function isNotNull(value) {
  return value !== null;
}
Overview.displayName = 'Overview';