"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationGuideView = exports.Indent = exports.BasicAlertDataContext = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var i18n = _interopRequireWildcard(require("./translations"));
var _markdown_editor = require("../markdown_editor");
var _line_clamp = require("../line_clamp");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Indent = exports.Indent = _styledComponents.default.div`
  padding: 0 8px;
  word-break: break-word;
`;
const BasicAlertDataContext = exports.BasicAlertDataContext = /*#__PURE__*/(0, _react.createContext)({});
/**
 * Investigation guide that shows the markdown text of rule.note
 */
const InvestigationGuideViewComponent = ({
  basicData,
  ruleNote,
  showFullView = false,
  showTitle = true
}) => {
  return /*#__PURE__*/_react.default.createElement(BasicAlertDataContext.Provider, {
    value: basicData
  }, showTitle && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    "data-test-subj": "summary-view-guide"
  }, /*#__PURE__*/_react.default.createElement("h5", null, i18n.INVESTIGATION_GUIDE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(Indent, null, showFullView ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": "investigation-guide-full-view"
  }, /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownRenderer, null, ruleNote)) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": "investigation-guide-clamped"
  }, /*#__PURE__*/_react.default.createElement(_line_clamp.LineClamp, {
    lineClampHeight: 4.5
  }, /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownRenderer, null, ruleNote)))));
};
const InvestigationGuideView = exports.InvestigationGuideView = /*#__PURE__*/_react.default.memo(InvestigationGuideViewComponent);