"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedAlertsBySession = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _helpers = require("../../../../helpers");
var _use_action_cell_data_provider = require("../table/use_action_cell_data_provider");
var _use_alert_prevalence = require("../../../containers/alerts/use_alert_prevalence");
var _insight_accordion = require("./insight_accordion");
var _investigate_in_timeline_button = require("../table/investigate_in_timeline_button");
var _simple_alert_table = require("./simple_alert_table");
var _helpers2 = require("../helpers");
var _translations = require("../../../../detections/components/alerts_table/translations");
var _translations2 = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Fetches the count of alerts that were generated in the same session
 * and displays an accordion with a mini table representation of the
 * related cases.
 * Offers the ability to dive deeper into the investigation by opening
 * the related alerts in a timeline investigation.
 */
const RelatedAlertsBySession = exports.RelatedAlertsBySession = /*#__PURE__*/_react.default.memo(({
  browserFields,
  data,
  eventId,
  scopeId
}) => {
  const {
    field,
    values
  } = data;
  const {
    error,
    count,
    alertIds
  } = (0, _use_alert_prevalence.useAlertPrevalence)({
    field,
    value: values,
    isActiveTimelines: (0, _helpers.isActiveTimeline)(scopeId),
    signalIndexName: null,
    includeAlertIds: true,
    ignoreTimerange: true
  });
  const {
    fieldFromBrowserField
  } = (0, _helpers2.getEnrichedFieldInfo)({
    browserFields,
    contextId: scopeId,
    eventId,
    field: {
      id: data.field
    },
    scopeId,
    item: data
  });
  const cellData = (0, _use_action_cell_data_provider.useActionCellDataProvider)({
    field,
    values,
    contextId: scopeId,
    eventId,
    fieldFromBrowserField,
    fieldFormat: fieldFromBrowserField === null || fieldFromBrowserField === void 0 ? void 0 : fieldFromBrowserField.format,
    fieldType: fieldFromBrowserField === null || fieldFromBrowserField === void 0 ? void 0 : fieldFromBrowserField.type
  });
  const isEmpty = count === 0;
  let state = 'loading';
  if (error) {
    state = 'error';
  } else if (alertIds || isEmpty) {
    state = 'success';
  }
  const renderContent = (0, _react.useCallback)(() => {
    if (!alertIds || !(cellData !== null && cellData !== void 0 && cellData.dataProviders)) {
      return null;
    } else if (isEmpty && state !== 'loading') {
      return _translations2.SESSION_EMPTY;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_simple_alert_table.SimpleAlertTable, {
      alertIds: alertIds
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_investigate_in_timeline_button.InvestigateInTimelineButton, {
      asEmptyButton: false,
      dataProviders: cellData === null || cellData === void 0 ? void 0 : cellData.dataProviders
    }, _translations.ACTION_INVESTIGATE_IN_TIMELINE));
  }, [alertIds, cellData === null || cellData === void 0 ? void 0 : cellData.dataProviders, isEmpty, state]);
  return /*#__PURE__*/_react.default.createElement(_insight_accordion.InsightAccordion, {
    prefix: "RelatedAlertsBySession",
    state: state,
    text: getTextFromState(state, count),
    renderContent: renderContent
  });
});
RelatedAlertsBySession.displayName = 'RelatedAlertsBySession';
function getTextFromState(state, count) {
  switch (state) {
    case 'loading':
      return _translations2.SESSION_LOADING;
    case 'error':
      return _translations2.SESSION_ERROR;
    case 'success':
      return (0, _translations2.SESSION_COUNT)(count);
    default:
      return '';
  }
}