"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatDetailsView = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _constants = require("../../../../../common/cti/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _enrichment_icon = require("./enrichment_icon");
var _enrichment_accordion_group = require("./enrichment_accordion_group");
var _enrichment_no_data = require("./enrichment_no_data");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnrichmentSectionHeader = ({
  type
}) => {
  return type ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, type === _constants.ENRICHMENT_TYPES.IndicatorMatchRule ? i18n.INDICATOR_ENRICHMENT_TITLE : i18n.INVESTIGATION_ENRICHMENT_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_enrichment_icon.EnrichmentIcon, {
    type: type
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })) : null;
};
const EnrichmentSection = ({
  enrichments,
  type,
  loading,
  dataTestSubj,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(EnrichmentSectionHeader, {
    type: type
  }), children, Array.isArray(enrichments) ? /*#__PURE__*/_react.default.createElement(_enrichment_accordion_group.EnrichmentAccordionGroup, {
    enrichments: enrichments
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_enrichment_no_data.EnrichmentNoData, {
    type: type
  }), loading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": "loading-enrichments",
    lines: 4
  }))));
};
const ThreatDetailsViewComponent = ({
  enrichments,
  before = null,
  showInvestigationTimeEnrichments,
  loading,
  children
}) => {
  const {
    [_constants.ENRICHMENT_TYPES.IndicatorMatchRule]: indicatorMatches,
    [_constants.ENRICHMENT_TYPES.InvestigationTime]: threatIntelEnrichments,
    undefined: matchesWithNoType
  } = (0, _lodash.groupBy)(enrichments, 'matched.type');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, before, /*#__PURE__*/_react.default.createElement(EnrichmentSection, {
    dataTestSubj: "threat-match-detected",
    enrichments: indicatorMatches,
    type: _constants.ENRICHMENT_TYPES.IndicatorMatchRule
  }), showInvestigationTimeEnrichments && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(EnrichmentSection, {
    dataTestSubj: "enriched-with-threat-intel",
    enrichments: threatIntelEnrichments,
    type: _constants.ENRICHMENT_TYPES.InvestigationTime,
    loading: loading
  }, children)), matchesWithNoType && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), indicatorMatches && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(EnrichmentSection, {
    enrichments: matchesWithNoType,
    dataTestSubj: "matches-with-no-type"
  })));
};
const ThreatDetailsView = exports.ThreatDetailsView = /*#__PURE__*/_react.default.memo(ThreatDetailsViewComponent);