"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSummaryView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _get_alert_summary_rows = require("./get_alert_summary_rows");
var _summary_view = require("./summary_view");
var _use_experimental_features = require("../../hooks/use_experimental_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertSummaryViewComponent = ({
  browserFields,
  data,
  eventId,
  isDraggable,
  scopeId,
  title,
  goToTable,
  isReadOnly,
  investigationFields
}) => {
  const sentinelOneManualHostActionsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('sentinelOneManualHostActionsEnabled');
  const summaryRows = (0, _react.useMemo)(() => (0, _get_alert_summary_rows.getSummaryRows)({
    browserFields,
    data,
    eventId,
    isDraggable,
    scopeId,
    isReadOnly,
    investigationFields,
    sentinelOneManualHostActionsEnabled
  }), [browserFields, data, eventId, isDraggable, scopeId, isReadOnly, investigationFields, sentinelOneManualHostActionsEnabled]);
  return /*#__PURE__*/_react.default.createElement(_summary_view.SummaryView, {
    goToTable: goToTable,
    isReadOnly: isReadOnly,
    rows: summaryRows,
    title: title
  });
};
const AlertSummaryView = exports.AlertSummaryView = /*#__PURE__*/_react.default.memo(AlertSummaryViewComponent);