"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendItem = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _translation = require("./translation");
var _validators = require("../../utils/validators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LegendText = _styledComponents.default.span`
  font-size: 10.5px;
`;

/**
 * Renders the value or a placeholder in case the value is empty
 */
const ValueWrapper = /*#__PURE__*/_react.default.memo(({
  value
}) => (0, _validators.hasValueToDisplay)(value) ? /*#__PURE__*/_react.default.createElement(LegendText, null, value) : /*#__PURE__*/_react.default.createElement(LegendText, {
  "data-test-subj": "value-wrapper-empty"
}, _translation.EMPTY_VALUE_LABEL));
ValueWrapper.displayName = 'ValueWrapper';
const LegendItemComponent = ({
  legendItem
}) => {
  const {
    color,
    value
  } = legendItem;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, color != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    "data-test-subj": "legend-color",
    color: color
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ValueWrapper, {
    value: value
  }))));
};
LegendItemComponent.displayName = 'LegendItemComponent';
const LegendItem = exports.LegendItem = /*#__PURE__*/_react.default.memo(LegendItemComponent);