"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MIN_LEGEND_HEIGHT = exports.DraggableLegend = exports.DEFAULT_WIDTH = void 0;
var _eui = require("@elastic/eui");
var _polished = require("polished");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _draggable_legend_item = require("./draggable_legend_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIN_LEGEND_HEIGHT = exports.MIN_LEGEND_HEIGHT = 175;
const DEFAULT_WIDTH = exports.DEFAULT_WIDTH = 165; // px

const DraggableLegendContainer = _styledComponents.default.div`
  height: ${({
  height
}) => `${height}px`};
  overflow: auto;
  scrollbar-width: thin;
  width: 100%;
  @media only screen and (min-width: ${({
  theme
}) => theme.eui.euiBreakpoints.m}) {
    width: 165px;
  }
  min-width: ${({
  $minWidth
}) => `${$minWidth}px`};

  &::-webkit-scrollbar {
    height: ${({
  theme
}) => theme.eui.euiScrollBar};
    width: ${({
  theme
}) => theme.eui.euiScrollBar};
  }

  &::-webkit-scrollbar-thumb {
    background-clip: content-box;
    background-color: ${({
  theme
}) => (0, _polished.rgba)(theme.eui.euiColorDarkShade, 0.5)};
    border: ${({
  theme
}) => theme.eui.euiScrollBarCorner} solid transparent;
  }

  &::-webkit-scrollbar-corner,
  &::-webkit-scrollbar-track {
    background-color: transparent;
  }
`;
const DraggableLegendComponent = ({
  className,
  height = 0,
  legendItems,
  minWidth = DEFAULT_WIDTH
}) => {
  if (legendItems.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(DraggableLegendContainer, {
    className: className,
    "data-test-subj": "draggable-legend",
    height: height === 0 ? MIN_LEGEND_HEIGHT : height,
    $minWidth: minWidth
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, legendItems.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: item.dataProviderId,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggable_legend_item.DraggableLegendItem, {
    legendItem: item
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    "data-test-subj": "draggable-legend-spacer",
    size: "s"
  }))))));
};
DraggableLegendComponent.displayName = 'DraggableLegendComponent';
const DraggableLegend = exports.DraggableLegend = /*#__PURE__*/_react.default.memo(DraggableLegendComponent);