"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useThemes = exports.getChartWidth = exports.getChartHeight = exports.defaultChartWidth = exports.defaultChartHeight = exports.checkIfAllValuesAreZero = exports.chartDefaultSettings = exports.Wrapper = exports.WrappedByAutoSizer = exports.SeriesType = exports.ChartWrapper = exports.BarChartWrapper = void 0;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _kibana = require("../../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultChartHeight = exports.defaultChartHeight = '100%';
const defaultChartWidth = exports.defaultChartWidth = '100%';
const chartDefaultRotation = 0;
const chartDefaultRendering = 'canvas';
const WrappedByAutoSizerComponent = _styledComponents.default.div`
  ${style => `
    height: ${style.height != null ? style.height : defaultChartHeight};
  `}
  position: relative;

  &:hover {
    z-index: 100;
  }
`;
WrappedByAutoSizerComponent.displayName = 'WrappedByAutoSizer';
const WrappedByAutoSizer = exports.WrappedByAutoSizer = /*#__PURE__*/_react.default.memo(WrappedByAutoSizerComponent);
let SeriesType = exports.SeriesType = /*#__PURE__*/function (SeriesType) {
  SeriesType["BAR"] = "bar";
  SeriesType["AREA"] = "area";
  SeriesType["LINE"] = "line";
  return SeriesType;
}({}); // Apply margins and paddings: https://ela.st/charts-spacing
const theme = {
  chartMargins: {
    left: 0,
    right: 0,
    // Apply some paddings to the top to avoid chopping the y tick https://ela.st/chopping-edge
    top: 4,
    bottom: 0
  },
  chartPaddings: {
    left: 0,
    right: 0,
    top: 0,
    bottom: 0
  },
  scales: {
    barsPadding: 0.05
  }
};
const useThemes = () => {
  const isDarkMode = (0, _kibana.useDarkMode)();
  // TODO connect to charts.theme service see src/plugins/charts/public/services/theme/README.md
  const baseTheme = isDarkMode ? _charts.LEGACY_DARK_THEME : _charts.LEGACY_LIGHT_THEME;
  return {
    baseTheme,
    theme
  };
};
exports.useThemes = useThemes;
const chartDefaultSettings = exports.chartDefaultSettings = {
  rotation: chartDefaultRotation,
  rendering: chartDefaultRendering,
  showLegend: false,
  showLegendExtra: false,
  debug: false,
  legendPosition: _charts.Position.Bottom
};
const getChartHeight = (customHeight, autoSizerHeight) => {
  const height = customHeight || autoSizerHeight;
  return height ? `${height}px` : defaultChartHeight;
};
exports.getChartHeight = getChartHeight;
const getChartWidth = (customWidth, autoSizerWidth) => {
  const height = customWidth || autoSizerWidth;
  return height ? `${height}px` : defaultChartWidth;
};
exports.getChartWidth = getChartWidth;
const checkIfAllValuesAreZero = data => Array.isArray(data) && data.every(series => {
  return Array.isArray(series.value) && series.value.every(({
    y
  }) => y === 0);
});
exports.checkIfAllValuesAreZero = checkIfAllValuesAreZero;
const Wrapper = exports.Wrapper = _styledComponents.default.div`
  position: relative;
`;
const ChartWrapper = exports.ChartWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  z-index: 0;
`;
const BarChartWrapper = exports.BarChartWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  z-index: 0;
  padding-right: 20px;
`;