"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartPlaceHolder = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common = require("./common");
var i18n = _interopRequireWildcard(require("./translation"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  height: ${({
  height
}) => height ? height : '100%'};
  width: ${({
  width
}) => width ? width : '100%'};
  position: relative;
  margin: 0;
`;
FlexGroup.displayName = 'FlexGroup';
const ChartPlaceHolder = ({
  height = '100%',
  width = '100%',
  data
}) => /*#__PURE__*/_react.default.createElement(FlexGroup, {
  justifyContent: "center",
  alignItems: "center",
  height: height,
  width: width
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  textAlign: "center",
  color: "subdued",
  "data-test-subj": "chartHolderText"
}, (0, _common.checkIfAllValuesAreZero)(data) ? i18n.ALL_VALUES_ZEROS_TITLE : i18n.DATA_NOT_AVAILABLE_TITLE)));
exports.ChartPlaceHolder = ChartPlaceHolder;