"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cloudDefendLink = void 0;
var _public = require("@kbn/cloud-defend-plugin/public");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _cloud_defend = require("../common/icons/cloud_defend");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const commonLinkProperties = {
  hideTimeline: true,
  capabilities: [`${_constants.SERVER_APP_ID}.show`]
};
const cloudDefendLink = exports.cloudDefendLink = {
  ...(0, _public.getSecuritySolutionLink)('policies'),
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.cloudDefendPoliciesDescription', {
    defaultMessage: 'Secure container workloads in Kubernetes from attacks and drift through granular and flexible runtime policies.'
  }),
  landingIcon: _cloud_defend.IconCloudDefend,
  ...commonLinkProperties
};