"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RELEASED_HOST = exports.PAGE_TITLE = exports.OTHER_ENDPOINTS = exports.ISOLATED_HOST = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_TITLE = exports.PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.cases.pageTitle', {
  defaultMessage: 'Cases'
});
const ISOLATED_HOST = exports.ISOLATED_HOST = _i18n.i18n.translate('xpack.securitySolution.caseView.isolatedHost', {
  defaultMessage: 'submitted isolate request on host'
});
const RELEASED_HOST = exports.RELEASED_HOST = _i18n.i18n.translate('xpack.securitySolution.caseView.releasedHost', {
  defaultMessage: 'submitted release request on host'
});
const OTHER_ENDPOINTS = endpoints => _i18n.i18n.translate('xpack.securitySolution.caseView.otherEndpoints', {
  values: {
    endpoints
  },
  defaultMessage: ` and {endpoints} {endpoints, plural, =1 {other} other {others}}`
});
exports.OTHER_ENDPOINTS = OTHER_ENDPOINTS;