"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAttackDiscovery = void 0;
var _elasticAssistant = require("@kbn/elastic-assistant");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _fp = require("lodash/fp");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var uuid = _interopRequireWildcard(require("uuid"));
var _use_fetch_anonymization_fields = require("@kbn/elastic-assistant/impl/assistant/api/anonymization_fields/use_fetch_anonymization_fields");
var _use_space_id = require("../../common/hooks/use_space_id");
var _kibana = require("../../common/lib/kibana");
var _helpers = require("../helpers");
var _use_attack_discovery_telemetry = require("../hooks/use_attack_discovery_telemetry");
var _helpers2 = require("../pages/helpers");
var _helpers3 = require("../pages/loading_callout/countdown/last_times_popover/helpers");
var _session_storage = require("../pages/session_storage");
var _translations = require("../pages/translations");
var _helpers4 = require("./helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_GENERATION_INTERVALS = 5;
const useAttackDiscovery = ({
  connectorId,
  setConnectorId,
  setLoadingConnectorId
}) => {
  var _cachedAttackDiscover, _cachedAttackDiscover2, _cachedAttackDiscover3, _cachedAttackDiscover4, _cachedAttackDiscover5, _cachedAttackDiscover6;
  const {
    reportAttackDiscoveriesGenerated
  } = (0, _use_attack_discovery_telemetry.useAttackDiscoveryTelemetry)();
  const spaceId = (0, _use_space_id.useSpaceId)();

  // get Kibana services and connectors
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const {
    data: aiConnectors
  } = (0, _elasticAssistant.useLoadConnectors)({
    http
  });

  // loading boilerplate:
  const [isLoading, setIsLoading] = (0, _react.useState)(false);

  // get alerts index pattern and allow lists from the assistant context:
  const {
    alertsIndexPattern,
    knowledgeBase,
    traceOptions
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    data: anonymizationFields
  } = (0, _use_fetch_anonymization_fields.useFetchAnonymizationFields)();
  const sessionStorageKey = (0, _react.useMemo)(() => spaceId != null // spaceId is undefined while the useSpaceId hook is loading
  ? `${_elasticAssistant.DEFAULT_ASSISTANT_NAMESPACE}.${_elasticAssistant.ATTACK_DISCOVERY_STORAGE_KEY}.${spaceId}.${_helpers2.CACHED_ATTACK_DISCOVERIES_SESSION_STORAGE_KEY}` : '', [spaceId]);
  const [cachedAttackDiscoveries, setCachedAttackDiscoveries] = (0, _react.useState)({});
  (0, _react.useEffect)(() => {
    const decoded = (0, _session_storage.getSessionStorageCachedAttackDiscoveries)(sessionStorageKey);
    if (decoded != null) {
      var _decoded, _decoded2, _decoded3;
      setCachedAttackDiscoveries(decoded);
      const decodedAttackDiscoveries = (_decoded = decoded[connectorId !== null && connectorId !== void 0 ? connectorId : '']) === null || _decoded === void 0 ? void 0 : _decoded.attackDiscoveries;
      if (decodedAttackDiscoveries != null) {
        setAttackDiscoveries(decodedAttackDiscoveries);
      }
      const decodedReplacements = (_decoded2 = decoded[connectorId !== null && connectorId !== void 0 ? connectorId : '']) === null || _decoded2 === void 0 ? void 0 : _decoded2.replacements;
      if (decodedReplacements != null) {
        setReplacements(decodedReplacements);
      }
      const decodedLastUpdated = (_decoded3 = decoded[connectorId !== null && connectorId !== void 0 ? connectorId : '']) === null || _decoded3 === void 0 ? void 0 : _decoded3.updated;
      if (decodedLastUpdated != null) {
        setLastUpdated(decodedLastUpdated);
      }
    }
  }, [connectorId, sessionStorageKey]);
  const localStorageKey = (0, _react.useMemo)(() => spaceId != null // spaceId is undefined while the useSpaceId hook is loading
  ? `${_elasticAssistant.DEFAULT_ASSISTANT_NAMESPACE}.${_elasticAssistant.ATTACK_DISCOVERY_STORAGE_KEY}.${spaceId}.${_helpers2.GENERATION_INTERVALS_LOCAL_STORAGE_KEY}` : '', [spaceId]);
  const [generationIntervals, setGenerationIntervals] = _react.default.useState(undefined);
  (0, _react.useEffect)(() => {
    const decoded = (0, _session_storage.getLocalStorageGenerationIntervals)(localStorageKey);
    if (decoded != null) {
      setGenerationIntervals(decoded);
    }
  }, [localStorageKey]);

  // get connector intervals from generation intervals:
  const connectorIntervals = (0, _react.useMemo)(() => {
    var _generationIntervals;
    return (_generationIntervals = generationIntervals === null || generationIntervals === void 0 ? void 0 : generationIntervals[connectorId !== null && connectorId !== void 0 ? connectorId : '']) !== null && _generationIntervals !== void 0 ? _generationIntervals : [];
  }, [connectorId, generationIntervals]);

  // generation can take a long time, so we calculate an approximate future time:
  const [approximateFutureTime, setApproximateFutureTime] = (0, _react.useState)(null);

  // get cached attack discoveries if they exist:
  const [attackDiscoveries, setAttackDiscoveries] = (0, _react.useState)((_cachedAttackDiscover = (_cachedAttackDiscover2 = cachedAttackDiscoveries[connectorId !== null && connectorId !== void 0 ? connectorId : '']) === null || _cachedAttackDiscover2 === void 0 ? void 0 : _cachedAttackDiscover2.attackDiscoveries) !== null && _cachedAttackDiscover !== void 0 ? _cachedAttackDiscover : []);

  // get replacements from the cached attack discoveries if they exist:
  const [replacements, setReplacements] = (0, _react.useState)((_cachedAttackDiscover3 = (_cachedAttackDiscover4 = cachedAttackDiscoveries[connectorId !== null && connectorId !== void 0 ? connectorId : '']) === null || _cachedAttackDiscover4 === void 0 ? void 0 : _cachedAttackDiscover4.replacements) !== null && _cachedAttackDiscover3 !== void 0 ? _cachedAttackDiscover3 : {});

  // get last updated from the cached attack discoveries if it exists:
  const [lastUpdated, setLastUpdated] = (0, _react.useState)((_cachedAttackDiscover5 = (_cachedAttackDiscover6 = cachedAttackDiscoveries[connectorId !== null && connectorId !== void 0 ? connectorId : '']) === null || _cachedAttackDiscover6 === void 0 ? void 0 : _cachedAttackDiscover6.updated) !== null && _cachedAttackDiscover5 !== void 0 ? _cachedAttackDiscover5 : null);

  // number of alerts sent as context to the LLM:
  const [alertsContextCount, setAlertsContextCount] = (0, _react.useState)(null);

  /** The callback when users click the Generate button */
  const fetchAttackDiscoveries = (0, _react.useCallback)(async () => {
    const selectedConnector = aiConnectors === null || aiConnectors === void 0 ? void 0 : aiConnectors.find(connector => connector.id === connectorId);
    const actionTypeId = (0, _helpers2.getFallbackActionTypeId)(selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.actionTypeId);
    const body = (0, _helpers4.getRequestBody)({
      actionTypeId,
      alertsIndexPattern,
      anonymizationFields,
      connectorId,
      knowledgeBase,
      traceOptions
    });
    try {
      var _parsedResponse$data$, _parsedResponse$data$2, _parsedResponse$data$3, _generationIntervals2, _parsedResponse$data$4;
      setLoadingConnectorId === null || setLoadingConnectorId === void 0 ? void 0 : setLoadingConnectorId(connectorId !== null && connectorId !== void 0 ? connectorId : null);
      setIsLoading(true);
      setApproximateFutureTime(null);
      const averageIntervalSeconds = (0, _helpers3.getAverageIntervalSeconds)(connectorIntervals);
      setApproximateFutureTime((0, _moment.default)().add(averageIntervalSeconds, 'seconds').toDate());
      const startTime = (0, _moment.default)(); // start timing the generation

      // call the internal API to generate attack discoveries:
      const rawResponse = await http.fetch('/internal/elastic_assistant/attack_discovery', {
        body: JSON.stringify(body),
        method: 'POST',
        version: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_INTERNAL_API_VERSION
      });
      const parsedResponse = _elasticAssistantCommon.AttackDiscoveryPostResponse.safeParse(rawResponse);
      if (!parsedResponse.success) {
        throw new Error('Failed to parse the response');
      }
      const endTime = (0, _moment.default)();
      const durationMs = endTime.diff(startTime);

      // update the cached attack discoveries with the new discoveries:
      const newAttackDiscoveries = (_parsedResponse$data$ = (_parsedResponse$data$2 = parsedResponse.data.attackDiscoveries) === null || _parsedResponse$data$2 === void 0 ? void 0 : _parsedResponse$data$2.map(attackDiscovery => ({
        alertIds: [...attackDiscovery.alertIds],
        detailsMarkdown: (0, _helpers.replaceNewlineLiterals)(attackDiscovery.detailsMarkdown),
        entitySummaryMarkdown: (0, _helpers.replaceNewlineLiterals)(attackDiscovery.entitySummaryMarkdown),
        id: uuid.v4(),
        mitreAttackTactics: attackDiscovery.mitreAttackTactics,
        summaryMarkdown: (0, _helpers.replaceNewlineLiterals)(attackDiscovery.summaryMarkdown),
        title: attackDiscovery.title
      }))) !== null && _parsedResponse$data$ !== void 0 ? _parsedResponse$data$ : [];
      const responseReplacements = (_parsedResponse$data$3 = parsedResponse.data.replacements) !== null && _parsedResponse$data$3 !== void 0 ? _parsedResponse$data$3 : {};
      const newReplacements = {
        ...replacements,
        ...responseReplacements
      };
      const newLastUpdated = new Date();
      const newCachedAttackDiscoveries = {
        ...cachedAttackDiscoveries,
        [connectorId !== null && connectorId !== void 0 ? connectorId : '']: {
          connectorId: connectorId !== null && connectorId !== void 0 ? connectorId : '',
          attackDiscoveries: newAttackDiscoveries,
          replacements: newReplacements,
          updated: newLastUpdated
        }
      };
      setCachedAttackDiscoveries(newCachedAttackDiscoveries);
      (0, _session_storage.setSessionStorageCachedAttackDiscoveries)({
        key: sessionStorageKey,
        cachedAttackDiscoveries: newCachedAttackDiscoveries
      });

      // update the generation intervals with the latest timing:
      const previousConnectorIntervals = generationIntervals != null ? (_generationIntervals2 = generationIntervals[connectorId !== null && connectorId !== void 0 ? connectorId : '']) !== null && _generationIntervals2 !== void 0 ? _generationIntervals2 : [] : [];
      const newInterval = {
        connectorId: connectorId !== null && connectorId !== void 0 ? connectorId : '',
        date: new Date(),
        durationMs
      };
      const newConnectorIntervals = [newInterval, ...previousConnectorIntervals].slice(0, MAX_GENERATION_INTERVALS);
      const newGenerationIntervals = {
        ...generationIntervals,
        [connectorId !== null && connectorId !== void 0 ? connectorId : '']: newConnectorIntervals
      };
      const newAlertsContextCount = (_parsedResponse$data$4 = parsedResponse.data.alertsContextCount) !== null && _parsedResponse$data$4 !== void 0 ? _parsedResponse$data$4 : null;
      setAlertsContextCount(newAlertsContextCount);

      // only update the generation intervals if alerts were sent as context to the LLM:
      if (newAlertsContextCount != null && newAlertsContextCount > 0) {
        setGenerationIntervals(newGenerationIntervals);
        (0, _session_storage.setLocalStorageGenerationIntervals)({
          key: localStorageKey,
          generationIntervals: newGenerationIntervals
        });
      }
      setReplacements(newReplacements);
      setAttackDiscoveries(newAttackDiscoveries);
      setLastUpdated(newLastUpdated);
      setConnectorId === null || setConnectorId === void 0 ? void 0 : setConnectorId(connectorId);
      const connectorConfig = (0, _helpers4.getGenAiConfig)(selectedConnector);
      reportAttackDiscoveriesGenerated({
        actionTypeId,
        durationMs,
        alertsContextCount: newAlertsContextCount !== null && newAlertsContextCount !== void 0 ? newAlertsContextCount : 0,
        alertsCount: (0, _fp.uniq)(newAttackDiscoveries.flatMap(attackDiscovery => attackDiscovery.alertIds)).length,
        configuredAlertsCount: knowledgeBase.latestAlerts,
        provider: connectorConfig === null || connectorConfig === void 0 ? void 0 : connectorConfig.apiProvider,
        model: connectorConfig === null || connectorConfig === void 0 ? void 0 : connectorConfig.defaultModel
      });
    } catch (error) {
      toasts === null || toasts === void 0 ? void 0 : toasts.addDanger(error, {
        title: _translations.ERROR_GENERATING_ATTACK_DISCOVERIES,
        text: (0, _helpers2.getErrorToastText)(error)
      });
    } finally {
      setApproximateFutureTime(null);
      setLoadingConnectorId === null || setLoadingConnectorId === void 0 ? void 0 : setLoadingConnectorId(null);
      setIsLoading(false);
    }
  }, [aiConnectors, alertsIndexPattern, anonymizationFields, cachedAttackDiscoveries, connectorId, connectorIntervals, generationIntervals, http, knowledgeBase, localStorageKey, replacements, reportAttackDiscoveriesGenerated, sessionStorageKey, setConnectorId, setLoadingConnectorId, toasts, traceOptions]);
  return {
    alertsContextCount,
    approximateFutureTime,
    attackDiscoveries,
    cachedAttackDiscoveries,
    fetchAttackDiscoveries,
    generationIntervals,
    isLoading,
    lastUpdated,
    replacements
  };
};
exports.useAttackDiscovery = useAttackDiscovery;