"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VideoToast = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _overview = _interopRequireDefault(require("./overview.gif"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VIDEO_CONTENT_WIDTH = 250;
const VIDEO_PAGE = `https://videos.elastic.co/watch/BrDaDBAAvdygvemFKNAkBW`;
const VideoComponent = ({
  onClose
}) => {
  const openVideoInNewTab = (0, _react.useCallback)(() => {
    window.open(VIDEO_PAGE, '_blank');
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "attackDiscovery-tour-step-2",
    css: {
      position: 'fixed',
      bottom: 16,
      right: 16,
      zIndex: 9999
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToast, {
    onClose: onClose,
    css: {
      maxWidth: VIDEO_CONTENT_WIDTH
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    onClick: openVideoInNewTab,
    css: {
      marginTop: 20,
      '&:hover': {
        cursor: 'pointer'
      }
    },
    src: _overview.default,
    "data-test-subj": "video-gif",
    alt: i18n.WATCH_OVERVIEW_VIDEO
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    grow: false,
    css: {
      marginTop: 20
    }
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "cheer",
    color: "success"
  }), " ", i18n.ATTACK_DISCOVERY_TOUR_VIDEO_STEP_TITLE), /*#__PURE__*/_react.default.createElement("p", null, i18n.ATTACK_DISCOVERY_TOUR_VIDEO_STEP_DESC)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    onClick: openVideoInNewTab,
    fullWidth: true
  }, i18n.WATCH_OVERVIEW_VIDEO))));
};
const VideoToast = exports.VideoToast = /*#__PURE__*/_react.default.memo(VideoComponent);