"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Summary = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _summary_count = require("../summary_count");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SummaryComponent = ({
  alertsCount,
  attackDiscoveriesCount,
  lastUpdated,
  onToggleShowAnonymized,
  showAnonymized
}) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
  "data-test-subj": "summary",
  justifyContent: "spaceBetween"
}, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react2.default.createElement(_summary_count.SummaryCount, {
  alertsCount: alertsCount,
  attackDiscoveriesCount: attackDiscoveriesCount,
  lastUpdated: lastUpdated
}), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
  size: "l"
})), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
  content: showAnonymized ? _translations.SHOW_REAL_VALUES : _translations.SHOW_ANONYMIZED_LABEL,
  "data-test-subj": "toggleAnonymizedToolTip"
}, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
  "aria-label": showAnonymized ? _translations.SHOW_REAL_VALUES : _translations.SHOW_ANONYMIZED_LABEL,
  css: (0, _react.css)`
            border-radius: 50%;
          `,
  "data-test-subj": "toggleAnonymized",
  iconType: showAnonymized ? 'eye' : 'eyeClosed',
  onClick: onToggleShowAnonymized
}))));
const Summary = exports.Summary = /*#__PURE__*/_react2.default.memo(SummaryComponent);