"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ATTACK_DISCOVERY_GENERATION_IN_PROGRESS = exports.AI_IS_CURRENTLY_ANALYZING = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AI_IS_CURRENTLY_ANALYZING = alertsCount => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.loadingCallout.aiIsCurrentlyAnalyzing', {
  defaultMessage: `AI is analyzing up to {alertsCount} {alertsCount, plural, =1 {alert} other {alerts}} in the last 24 hours to generate discoveries.`,
  values: {
    alertsCount
  }
});
exports.AI_IS_CURRENTLY_ANALYZING = AI_IS_CURRENTLY_ANALYZING;
const ATTACK_DISCOVERY_GENERATION_IN_PROGRESS = exports.ATTACK_DISCOVERY_GENERATION_IN_PROGRESS = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.loadingCallout.attackDiscoveryGenerationInProgressLabel', {
  defaultMessage: 'Attack discovery in progress'
});