"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingCallout = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _kibana = require("../../../common/lib/kibana");
var _countdown = require("./countdown");
var _loading_messages = require("./loading_messages");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BACKGROUND_COLOR_LIGHT = '#E6F1FA';
const BACKGROUND_COLOR_DARK = '#0B2030';
const BORDER_COLOR_DARK = '#0B2030';
const LoadingCalloutComponent = ({
  alertsCount,
  approximateFutureTime,
  connectorIntervals
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    theme
  } = (0, _kibana.useKibana)().services;
  const leftContent = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "leftContent",
    gutterSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingElastic, {
    "data-test-subj": "loadingElastic",
    size: "l"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
            margin-left: ${euiTheme.size.m};
          `,
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_loading_messages.LoadingMessages, {
    alertsCount: alertsCount
  }))), [alertsCount, euiTheme.size.m]);
  const isDarkMode = theme.getTheme().darkMode === true;
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        background-color: ${isDarkMode ? BACKGROUND_COLOR_DARK : BACKGROUND_COLOR_LIGHT};
        border: 1px solid ${isDarkMode ? BORDER_COLOR_DARK : euiTheme.colors.lightShade};
        border-radius: 6px;
        padding: ${euiTheme.size.base};
      `,
    "data-test-subj": "loadingCallout"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, leftContent), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_countdown.Countdown, {
    approximateFutureTime: approximateFutureTime,
    connectorIntervals: connectorIntervals
  }))));
};
LoadingCalloutComponent.displayName = 'LoadingCallout';
const LoadingCallout = exports.LoadingCallout = /*#__PURE__*/_react2.default.memo(LoadingCalloutComponent);