"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoveryPage = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _fp = require("lodash/fp");
var _react2 = _interopRequireWildcard(require("react"));
var _reactUse = require("react-use");
var _security_route_page_wrapper = require("../../common/components/security_route_page_wrapper");
var _constants = require("../../../common/constants");
var _header_page = require("../../common/components/header_page");
var _use_space_id = require("../../common/hooks/use_space_id");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _header = require("./header");
var _helpers = require("./helpers");
var _attack_discovery_panel = require("../attack_discovery_panel");
var _empty_states = require("./empty_states");
var _loading_callout = require("./loading_callout");
var _page_title = require("./page_title");
var _summary = require("./summary");
var _upgrade = require("./upgrade");
var _use_attack_discovery = require("../use_attack_discovery");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AttackDiscoveryPageComponent = () => {
  var _useSpaceId, _cachedAttackDiscover, _cachedAttackDiscover2, _cachedAttackDiscover3, _cachedAttackDiscover4, _cachedAttackDiscover5, _cachedAttackDiscover6, _aiConnectors$length;
  const spaceId = (_useSpaceId = (0, _use_space_id.useSpaceId)()) !== null && _useSpaceId !== void 0 ? _useSpaceId : 'default';
  const {
    assistantAvailability: {
      isAssistantEnabled
    },
    http,
    knowledgeBase
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    data: aiConnectors
  } = (0, _elasticAssistant.useLoadConnectors)({
    http
  });

  // for showing / hiding anonymized data:
  const [showAnonymized, setShowAnonymized] = (0, _react2.useState)(false);
  const onToggleShowAnonymized = (0, _react2.useCallback)(() => setShowAnonymized(current => !current), []);

  // get the last selected connector ID from local storage:
  const [localStorageAttackDiscoveryConnectorId, setLocalStorageAttackDiscoveryConnectorId] = (0, _reactUse.useLocalStorage)(`${_elasticAssistant.DEFAULT_ASSISTANT_NAMESPACE}.${_elasticAssistant.ATTACK_DISCOVERY_STORAGE_KEY}.${spaceId}.${_helpers.CONNECTOR_ID_LOCAL_STORAGE_KEY}`);
  const [connectorId, setConnectorId] = _react2.default.useState(localStorageAttackDiscoveryConnectorId);

  // state for the connector loading in the background:
  const [loadingConnectorId, setLoadingConnectorId] = (0, _react2.useState)(null);
  const {
    alertsContextCount,
    approximateFutureTime,
    attackDiscoveries,
    cachedAttackDiscoveries,
    fetchAttackDiscoveries,
    generationIntervals,
    isLoading,
    lastUpdated,
    replacements
  } = (0, _use_attack_discovery.useAttackDiscovery)({
    connectorId,
    setConnectorId,
    setLoadingConnectorId
  });

  // get last updated from the cached attack discoveries if it exists:
  const [selectedConnectorLastUpdated, setSelectedConnectorLastUpdated] = (0, _react2.useState)((_cachedAttackDiscover = (_cachedAttackDiscover2 = cachedAttackDiscoveries[connectorId !== null && connectorId !== void 0 ? connectorId : '']) === null || _cachedAttackDiscover2 === void 0 ? void 0 : _cachedAttackDiscover2.updated) !== null && _cachedAttackDiscover !== void 0 ? _cachedAttackDiscover : null);

  // get cached attack discoveries if they exist:
  const [selectedConnectorAttackDiscoveries, setSelectedConnectorAttackDiscoveries] = (0, _react2.useState)((_cachedAttackDiscover3 = (_cachedAttackDiscover4 = cachedAttackDiscoveries[connectorId !== null && connectorId !== void 0 ? connectorId : '']) === null || _cachedAttackDiscover4 === void 0 ? void 0 : _cachedAttackDiscover4.attackDiscoveries) !== null && _cachedAttackDiscover3 !== void 0 ? _cachedAttackDiscover3 : []);

  // get replacements from the cached attack discoveries if they exist:
  const [selectedConnectorReplacements, setSelectedConnectorReplacements] = (0, _react2.useState)((_cachedAttackDiscover5 = (_cachedAttackDiscover6 = cachedAttackDiscoveries[connectorId !== null && connectorId !== void 0 ? connectorId : '']) === null || _cachedAttackDiscover6 === void 0 ? void 0 : _cachedAttackDiscover6.replacements) !== null && _cachedAttackDiscover5 !== void 0 ? _cachedAttackDiscover5 : {});

  // the number of unique alerts in the attack discoveries:
  const alertsCount = (0, _react2.useMemo)(() => (0, _fp.uniq)(selectedConnectorAttackDiscoveries.flatMap(attackDiscovery => attackDiscovery.alertIds)).length, [selectedConnectorAttackDiscoveries]);

  /** The callback when users select a connector ID */
  const onConnectorIdSelected = (0, _react2.useCallback)(selectedConnectorId => {
    // update the connector ID in local storage:
    setConnectorId(selectedConnectorId);
    setLocalStorageAttackDiscoveryConnectorId(selectedConnectorId);

    // get the cached attack discoveries for the selected connector:
    const cached = cachedAttackDiscoveries[selectedConnectorId];
    if (cached != null) {
      var _cached$replacements, _cached$attackDiscove, _cached$updated;
      setSelectedConnectorReplacements((_cached$replacements = cached.replacements) !== null && _cached$replacements !== void 0 ? _cached$replacements : {});
      setSelectedConnectorAttackDiscoveries((_cached$attackDiscove = cached.attackDiscoveries) !== null && _cached$attackDiscove !== void 0 ? _cached$attackDiscove : []);
      setSelectedConnectorLastUpdated((_cached$updated = cached.updated) !== null && _cached$updated !== void 0 ? _cached$updated : null);
    } else {
      setSelectedConnectorReplacements({});
      setSelectedConnectorAttackDiscoveries([]);
      setSelectedConnectorLastUpdated(null);
    }
  }, [cachedAttackDiscoveries, setLocalStorageAttackDiscoveryConnectorId]);

  // get connector intervals from generation intervals:
  const connectorIntervals = (0, _react2.useMemo)(() => {
    var _generationIntervals;
    return (_generationIntervals = generationIntervals === null || generationIntervals === void 0 ? void 0 : generationIntervals[connectorId !== null && connectorId !== void 0 ? connectorId : '']) !== null && _generationIntervals !== void 0 ? _generationIntervals : [];
  }, [connectorId, generationIntervals]);
  const pageTitle = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_page_title.PageTitle, null), []);
  const onGenerate = (0, _react2.useCallback)(async () => fetchAttackDiscoveries(), [fetchAttackDiscoveries]);
  (0, _react2.useEffect)(() => {
    setSelectedConnectorReplacements(replacements);
    setSelectedConnectorAttackDiscoveries(attackDiscoveries);
    setSelectedConnectorLastUpdated(lastUpdated);
  }, [attackDiscoveries, lastUpdated, replacements]);
  (0, _react2.useEffect)(() => {
    // If there is only one connector, set it as the selected connector
    if (aiConnectors != null && aiConnectors.length === 1) {
      setConnectorId(aiConnectors[0].id);
    }
  }, [aiConnectors, setConnectorId]);
  const attackDiscoveriesCount = selectedConnectorAttackDiscoveries.length;
  if (!isAssistantEnabled) {
    return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "xxl"
    }), /*#__PURE__*/_react2.default.createElement(_upgrade.Upgrade, null));
  }
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        display: flex;
        flex-direction: column;
        flex: 1 1 auto;
      `,
    "data-test-subj": "fullHeightContainer"
  }, /*#__PURE__*/_react2.default.createElement(_security_route_page_wrapper.SecurityRoutePageWrapper, {
    "data-test-subj": "attackDiscoveryPage",
    pageName: _constants.SecurityPageName.attackDiscovery
  }, /*#__PURE__*/_react2.default.createElement(_header_page.HeaderPage, {
    border: true,
    title: pageTitle
  }, /*#__PURE__*/_react2.default.createElement(_header.Header, {
    connectorId: connectorId,
    connectorsAreConfigured: aiConnectors != null && aiConnectors.length > 0,
    isLoading: isLoading,
    onConnectorIdSelected: onConnectorIdSelected,
    onGenerate: onGenerate
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), (0, _helpers.showSummary)({
    attackDiscoveriesCount,
    connectorId,
    loadingConnectorId
  }) && /*#__PURE__*/_react2.default.createElement(_summary.Summary, {
    alertsCount: alertsCount,
    attackDiscoveriesCount: attackDiscoveriesCount,
    lastUpdated: selectedConnectorLastUpdated,
    onToggleShowAnonymized: onToggleShowAnonymized,
    showAnonymized: showAnonymized
  }), /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, (0, _helpers.showLoading)({
    attackDiscoveriesCount,
    connectorId,
    isLoading,
    loadingConnectorId
  }) ? /*#__PURE__*/_react2.default.createElement(_loading_callout.LoadingCallout, {
    alertsCount: knowledgeBase.latestAlerts,
    approximateFutureTime: approximateFutureTime,
    connectorIntervals: connectorIntervals
  }) : selectedConnectorAttackDiscoveries.map((attackDiscovery, i) => /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, {
    key: attackDiscovery.id
  }, /*#__PURE__*/_react2.default.createElement(_attack_discovery_panel.AttackDiscoveryPanel, {
    attackDiscovery: attackDiscovery,
    initialIsOpen: (0, _helpers.getInitialIsOpen)(i),
    showAnonymized: showAnonymized,
    replacements: selectedConnectorReplacements
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
            max-height: 100%;
            min-height: 100%;
          `,
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_empty_states.EmptyStates, {
    aiConnectorsCount: (_aiConnectors$length = aiConnectors === null || aiConnectors === void 0 ? void 0 : aiConnectors.length) !== null && _aiConnectors$length !== void 0 ? _aiConnectors$length : null,
    alertsContextCount: alertsContextCount,
    alertsCount: knowledgeBase.latestAlerts,
    attackDiscoveriesCount: attackDiscoveriesCount,
    connectorId: connectorId,
    isLoading: isLoading,
    onGenerate: onGenerate
  }))), /*#__PURE__*/_react2.default.createElement(_spy_routes.SpyRoute, {
    pageName: _constants.SecurityPageName.attackDiscovery
  })));
};
AttackDiscoveryPageComponent.displayName = 'AttackDiscoveryPage';
const AttackDiscoveryPage = exports.AttackDiscoveryPage = /*#__PURE__*/_react2.default.memo(AttackDiscoveryPageComponent);