"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialIsOpen = exports.getFallbackActionTypeId = exports.getErrorToastText = exports.GENERATION_INTERVALS_LOCAL_STORAGE_KEY = exports.CONNECTOR_ID_LOCAL_STORAGE_KEY = exports.CACHED_ATTACK_DISCOVERIES_SESSION_STORAGE_KEY = void 0;
exports.isErrorWithStringMessage = isErrorWithStringMessage;
exports.isErrorWithStructuredMessage = isErrorWithStructuredMessage;
exports.showWelcomePrompt = exports.showSummary = exports.showNoAlertsPrompt = exports.showLoading = exports.showEmptyPrompt = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInitialIsOpen = index => index < 3;
exports.getInitialIsOpen = getInitialIsOpen;
const getFallbackActionTypeId = actionTypeId => actionTypeId != null ? actionTypeId : '.gen-ai';
exports.getFallbackActionTypeId = getFallbackActionTypeId;
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function isErrorWithStringMessage(error) {
  var _error$body, _error$body2, _error$body3;
  const errorBodyError = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.error;
  const errorBodyMessage = (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message;
  const errorBodyStatusCode = (_error$body3 = error.body) === null || _error$body3 === void 0 ? void 0 : _error$body3.statusCode;
  return typeof errorBodyError === 'string' && typeof errorBodyMessage === 'string' && typeof errorBodyStatusCode === 'number';
}
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function isErrorWithStructuredMessage(error) {
  var _error$body4, _error$body4$message, _error$body5;
  const errorBodyMessageError = (_error$body4 = error.body) === null || _error$body4 === void 0 ? void 0 : (_error$body4$message = _error$body4.message) === null || _error$body4$message === void 0 ? void 0 : _error$body4$message.error;
  const errorBodyStatusCode = (_error$body5 = error.body) === null || _error$body5 === void 0 ? void 0 : _error$body5.status_code;
  return typeof errorBodyMessageError === 'string' && typeof errorBodyStatusCode === 'number';
}
const CONNECTOR_ID_LOCAL_STORAGE_KEY = exports.CONNECTOR_ID_LOCAL_STORAGE_KEY = 'connectorId';
const CACHED_ATTACK_DISCOVERIES_SESSION_STORAGE_KEY = exports.CACHED_ATTACK_DISCOVERIES_SESSION_STORAGE_KEY = 'cachedAttackDiscoveries';
const GENERATION_INTERVALS_LOCAL_STORAGE_KEY = exports.GENERATION_INTERVALS_LOCAL_STORAGE_KEY = 'generationIntervals';
const getErrorToastText = error => {
  if (isErrorWithStringMessage(error)) {
    var _error$body6, _error$body7, _error$body8;
    return `${(_error$body6 = error.body) === null || _error$body6 === void 0 ? void 0 : _error$body6.error} (${(_error$body7 = error.body) === null || _error$body7 === void 0 ? void 0 : _error$body7.statusCode}) ${(_error$body8 = error.body) === null || _error$body8 === void 0 ? void 0 : _error$body8.message}`;
  } else if (isErrorWithStructuredMessage(error)) {
    var _error$body9, _error$body10, _error$body10$message;
    return `(${(_error$body9 = error.body) === null || _error$body9 === void 0 ? void 0 : _error$body9.status_code}) ${(_error$body10 = error.body) === null || _error$body10 === void 0 ? void 0 : (_error$body10$message = _error$body10.message) === null || _error$body10$message === void 0 ? void 0 : _error$body10$message.error}`;
  } else if (typeof error === 'object' && error != null && 'message' in error && typeof error.message === 'string') {
    return error.message;
  } else {
    return `${error}`;
  }
};
exports.getErrorToastText = getErrorToastText;
const showNoAlertsPrompt = ({
  alertsContextCount,
  isLoading
}) => !isLoading && alertsContextCount != null && alertsContextCount === 0;
exports.showNoAlertsPrompt = showNoAlertsPrompt;
const showWelcomePrompt = ({
  aiConnectorsCount,
  isLoading
}) => !isLoading && aiConnectorsCount != null && aiConnectorsCount === 0;
exports.showWelcomePrompt = showWelcomePrompt;
const showEmptyPrompt = ({
  attackDiscoveriesCount,
  isLoading
}) => !isLoading && attackDiscoveriesCount === 0;
exports.showEmptyPrompt = showEmptyPrompt;
const showLoading = ({
  connectorId,
  attackDiscoveriesCount,
  isLoading,
  loadingConnectorId
}) => isLoading && (loadingConnectorId === connectorId || attackDiscoveriesCount === 0);
exports.showLoading = showLoading;
const showSummary = ({
  connectorId,
  attackDiscoveriesCount,
  loadingConnectorId
}) => loadingConnectorId !== connectorId && attackDiscoveriesCount > 0;
exports.showSummary = showSummary;