"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsTab = void 0;
var _technical_rule_data_field_names = require("@kbn/rule-registry-plugin/common/technical_rule_data_field_names");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsTabComponent = ({
  attackDiscovery,
  replacements
}) => {
  const {
    triggersActionsUi
  } = (0, _kibana.useKibana)().services;
  const originalAlertIds = (0, _react.useMemo)(() => attackDiscovery.alertIds.map(alertId => {
    var _replacements$alertId;
    return replacements != null ? (_replacements$alertId = replacements[alertId]) !== null && _replacements$alertId !== void 0 ? _replacements$alertId : alertId : alertId;
  }), [attackDiscovery.alertIds, replacements]);
  const alertIdsQuery = (0, _react.useMemo)(() => ({
    ids: {
      values: originalAlertIds
    }
  }), [originalAlertIds]);
  const configId = _constants.ALERTS_TABLE_REGISTRY_CONFIG_IDS.CASE; // show the same row-actions as in the case view

  const alertStateProps = (0, _react.useMemo)(() => ({
    alertsTableConfigurationRegistry: triggersActionsUi.alertsTableConfigurationRegistry,
    configurationId: configId,
    id: `attack-discovery-alerts-${attackDiscovery.id}`,
    featureIds: [_technical_rule_data_field_names.AlertConsumers.SIEM],
    query: alertIdsQuery,
    showAlertStatusWithFlapping: false
  }), [alertIdsQuery, attackDiscovery.id, configId, triggersActionsUi.alertsTableConfigurationRegistry]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "alertsTab"
  }, triggersActionsUi.getAlertsStateTable(alertStateProps));
};
AlertsTabComponent.displayName = 'AlertsTab';
const AlertsTab = exports.AlertsTab = /*#__PURE__*/_react.default.memo(AlertsTabComponent);