"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CREATE_A_CASE_FOR_ATTACK_DISCOVERY = exports.ADD_TO_NEW_CASE = exports.ADD_TO_CASE_SUCCESS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_TO_CASE_SUCCESS = exports.ADD_TO_CASE_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.attackDiscoveryPanel.actions.useAddToCase.addToCaseSuccessLabel', {
  defaultMessage: 'Successfully added attack discovery to the case'
});
const ADD_TO_NEW_CASE = exports.ADD_TO_NEW_CASE = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.attackDiscoveryPanel.actions.useAddToCase.addToNewCaseButtonLabel', {
  defaultMessage: 'Add to new case'
});
const CREATE_A_CASE_FOR_ATTACK_DISCOVERY = title => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.attackDiscoveryPanel.actions.useAddToCase.createACaseForAttackDiscoveryHeaderText', {
  values: {
    title
  },
  defaultMessage: 'Create a case for attack discovery {title}'
});
exports.CREATE_A_CASE_FOR_ATTACK_DISCOVERY = CREATE_A_CASE_FOR_ATTACK_DISCOVERY;