"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TakeAction = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../../../common/lib/kibana");
var _common = require("../../../../../common");
var _get_attack_discovery_markdown = require("../../../get_attack_discovery_markdown/get_attack_discovery_markdown");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_add_to_case = require("../use_add_to_case");
var _use_add_to_existing_case = require("../use_add_to_existing_case");
var _use_view_in_ai_assistant = require("../../view_in_ai_assistant/use_view_in_ai_assistant");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TakeActionComponent = ({
  attackDiscovery,
  replacements
}) => {
  // get dependencies for creating / adding to cases:
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const userCasesPermissions = cases.helpers.canUseCases([_common.APP_ID]);
  const canUserCreateAndReadCases = (0, _react.useCallback)(() => userCasesPermissions.create && userCasesPermissions.read, [userCasesPermissions.create, userCasesPermissions.read]);
  const {
    disabled: addToCaseDisabled,
    onAddToNewCase
  } = (0, _use_add_to_case.useAddToNewCase)({
    canUserCreateAndReadCases,
    title: attackDiscovery.title
  });
  const {
    onAddToExistingCase
  } = (0, _use_add_to_existing_case.useAddToExistingCase)({
    canUserCreateAndReadCases
  });

  // boilerplate for the take action popover:
  const takeActionContextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'takeActionContextMenuPopover'
  });
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => setPopover(!isPopoverOpen), [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => setPopover(false), []);

  // markdown for the attack discovery, which will be exported to the case, or to the assistant:
  const markdown = (0, _react.useMemo)(() => (0, _get_attack_discovery_markdown.getAttackDiscoveryMarkdown)({
    attackDiscovery,
    replacements
  }), [attackDiscovery, replacements]);

  // click handlers for the popover actions:
  const onClickAddToNewCase = (0, _react.useCallback)(() => {
    closePopover();
    onAddToNewCase({
      alertIds: attackDiscovery.alertIds,
      markdownComments: [markdown],
      replacements
    });
  }, [closePopover, attackDiscovery.alertIds, markdown, onAddToNewCase, replacements]);
  const onClickAddToExistingCase = (0, _react.useCallback)(() => {
    closePopover();
    onAddToExistingCase({
      alertIds: attackDiscovery.alertIds,
      markdownComments: [markdown],
      replacements
    });
  }, [closePopover, attackDiscovery.alertIds, markdown, onAddToExistingCase, replacements]);
  const {
    showAssistantOverlay,
    disabled: viewInAiAssistantDisabled
  } = (0, _use_view_in_ai_assistant.useViewInAiAssistant)({
    attackDiscovery,
    replacements
  });
  const onViewInAiAssistant = (0, _react.useCallback)(() => {
    closePopover();
    showAssistantOverlay === null || showAssistantOverlay === void 0 ? void 0 : showAssistantOverlay();
  }, [closePopover, showAssistantOverlay]);

  // button for the popover:
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "takeActionPopoverButton",
    iconSide: "right",
    iconType: "arrowDown",
    onClick: onButtonClick,
    size: "s"
  }, i18n.TAKE_ACTION), [onButtonClick]);

  // items for the popover:
  const items = (0, _react.useMemo)(() => [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "addToCase",
    disabled: addToCaseDisabled,
    key: "addToCase",
    onClick: onClickAddToNewCase
  }, i18n.ADD_TO_NEW_CASE), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "addToExistingCase",
    disabled: addToCaseDisabled,
    key: "addToExistingCase",
    onClick: onClickAddToExistingCase
  }, i18n.ADD_TO_EXISTING_CASE), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "viewInAiAssistant",
    disabled: viewInAiAssistantDisabled,
    key: "viewInAiAssistant",
    onClick: onViewInAiAssistant
  }, i18n.VIEW_IN_AI_ASSISTANT)], [addToCaseDisabled, onClickAddToExistingCase, onClickAddToNewCase, onViewInAiAssistant, viewInAiAssistantDisabled]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downCenter",
    button: button,
    closePopover: closePopover,
    "data-test-subj": "takeAction",
    id: takeActionContextMenuPopoverId,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items
  }));
};
TakeActionComponent.displayName = 'TakeAction';
const TakeAction = exports.TakeAction = /*#__PURE__*/_react.default.memo(TakeActionComponent);