"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionableSummary = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _attack_discovery_markdown_formatter = require("../../attack_discovery_markdown_formatter");
var _view_in_ai_assistant = require("../view_in_ai_assistant");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionableSummaryComponent = ({
  attackDiscovery,
  replacements,
  showAnonymized = false
}) => {
  const entitySummaryMarkdownWithReplacements = (0, _react.useMemo)(() => Object.entries(replacements !== null && replacements !== void 0 ? replacements : {}).reduce((acc, [key, value]) => acc.replace(key, value), attackDiscovery.entitySummaryMarkdown), [attackDiscovery.entitySummaryMarkdown, replacements]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    "data-test-subj": "actionableSummary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "entitySummaryMarkdown",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_attack_discovery_markdown_formatter.AttackDiscoveryMarkdownFormatter, {
    disableActions: showAnonymized,
    markdown: showAnonymized ? attackDiscovery.entitySummaryMarkdown : entitySummaryMarkdownWithReplacements
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_view_in_ai_assistant.ViewInAiAssistant, {
    compact: true,
    attackDiscovery: attackDiscovery,
    replacements: replacements
  }))));
};
ActionableSummaryComponent.displayName = 'ActionableSummary';
const ActionableSummary = exports.ActionableSummary = /*#__PURE__*/_react.default.memo(ActionableSummaryComponent);