"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldMarkdownRenderer = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _draggables = require("../../../common/components/draggables");
var _helpers = require("./helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const contextId = 'FieldMarkdownRenderer';
const getFieldMarkdownRenderer = disableActions => {
  const FieldMarkdownRenderer = ({
    icon,
    name,
    value
  }) => {
    const {
      openRightPanel
    } = (0, _expandableFlyout.useExpandableFlyoutApi)();
    const flyoutPanelProps = (0, _react.useMemo)(() => (0, _helpers.getFlyoutPanelProps)({
      contextId,
      fieldName: name,
      value
    }), [name, value]);
    const onEntityClick = (0, _react.useCallback)(() => {
      if (flyoutPanelProps != null) {
        openRightPanel(flyoutPanelProps);
      }
    }, [flyoutPanelProps, openRightPanel]);
    const entityButton = (0, _react.useMemo)(() => flyoutPanelProps != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "entityButton",
      flush: "both",
      onClick: onEntityClick,
      size: "xs"
    }, value) : null, [flyoutPanelProps, onEntityClick, value]);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: name,
      "data-test-subj": "fieldMarkdownRendererToolTip",
      position: "top"
    }, disableActions ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      "data-test-subj": "disabledActionsBadge",
      iconType: icon
    }, value) : /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: "fieldMarkdownRenderer",
      eventId: "",
      iconType: icon,
      isAggregatable: false,
      isDraggable: false,
      field: name,
      value: value
    }, entityButton));
  };
  return FieldMarkdownRenderer;
};
exports.getFieldMarkdownRenderer = getFieldMarkdownRenderer;