"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _assistant_settings_management = require("@kbn/elastic-assistant/impl/assistant/settings/assistant_settings_management");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _use_conversation = require("@kbn/elastic-assistant/impl/assistant/use_conversation");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManagementSettings = exports.ManagementSettings = /*#__PURE__*/_react.default.memo(() => {
  const isFlyoutMode = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('aiAssistantFlyoutMode');
  const {
    baseConversations,
    http,
    assistantAvailability: {
      isAssistantEnabled
    }
  } = (0, _elasticAssistant.useAssistantContext)();
  const onFetchedConversations = (0, _react.useCallback)(conversationsData => (0, _elasticAssistant.mergeBaseWithPersistedConversations)(baseConversations, conversationsData), [baseConversations]);
  const {
    data: conversations
  } = (0, _elasticAssistant.useFetchCurrentUserConversations)({
    http,
    onFetch: onFetchedConversations,
    isAssistantEnabled
  });
  const [selectedConversationId, setSelectedConversationId] = (0, _react.useState)(_elasticAssistant.WELCOME_CONVERSATION_TITLE);
  const {
    getDefaultConversation
  } = (0, _use_conversation.useConversation)();
  const currentConversation = (0, _react.useMemo)(() => {
    var _conversations$select;
    return (_conversations$select = conversations === null || conversations === void 0 ? void 0 : conversations[selectedConversationId]) !== null && _conversations$select !== void 0 ? _conversations$select : getDefaultConversation({
      cTitle: _elasticAssistant.WELCOME_CONVERSATION_TITLE,
      isFlyoutMode
    });
  }, [conversations, getDefaultConversation, selectedConversationId, isFlyoutMode]);
  if (conversations) {
    return /*#__PURE__*/_react.default.createElement(_assistant_settings_management.AssistantSettingsManagement, {
      selectedConversation: currentConversation,
      setSelectedConversationId: setSelectedConversationId,
      conversations: conversations,
      isFlyoutMode: isFlyoutMode
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
});
ManagementSettings.displayName = 'ManagementSettings';