"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantHeaderLink = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _assistant_context = require("@kbn/elastic-assistant/impl/assistant_context");
var _elasticAssistant = require("@kbn/elastic-assistant");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isMac = navigator.platform.toLowerCase().indexOf('mac') >= 0;
const TOOLTIP_CONTENT = _i18n.i18n.translate('xpack.securitySolution.globalHeader.assistantHeaderLinkShortcutTooltip', {
  values: {
    keyboardShortcut: isMac ? '⌘ ;' : 'Ctrl ;'
  },
  defaultMessage: 'Keyboard shortcut {keyboardShortcut}'
});
const LINK_LABEL = _i18n.i18n.translate('xpack.securitySolution.globalHeader.assistantHeaderLink', {
  defaultMessage: 'AI Assistant'
});

/**
 * Elastic AI Assistant header link
 */
const AssistantHeaderLink = () => {
  const {
    showAssistantOverlay,
    assistantAvailability
  } = (0, _assistant_context.useAssistantContext)();
  const showOverlay = (0, _react.useCallback)(() => showAssistantOverlay({
    showOverlay: true
  }), [showAssistantOverlay]);
  if (!assistantAvailability.hasAssistantPrivilege) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: TOOLTIP_CONTENT
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    "data-test-subj": "assistantHeaderLink",
    color: "primary",
    onClick: showOverlay
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.AssistantAvatar, {
    size: "xs"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, LINK_LABEL))));
};
exports.AssistantHeaderLink = AssistantHeaderLink;