"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getComments = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _elasticAssistant = require("@kbn/elastic-assistant");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _stream = require("./stream");
var _comment_actions = require("../comment_actions");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Matches EuiAvatar L
const SpinnerWrapper = _styled.default.div`
  width: 40px;
  height: 40px;
  display: flex;
  justify-content: center;
`;
const transformMessageWithReplacements = ({
  message,
  content,
  showAnonymizedValues,
  replacements
}) => {
  return {
    ...message,
    content: showAnonymizedValues ? content : (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
      messageContent: content,
      replacements
    })
  };
};
const getComments = ({
  abortStream,
  currentConversation,
  isEnabledLangChain,
  isFetchingResponse,
  refetchCurrentConversation,
  regenerateMessage,
  showAnonymizedValues,
  isFlyoutMode,
  currentUserAvatar,
  setIsStreaming
}) => {
  var _currentConversation$, _currentConversation$2;
  if (!currentConversation) return [];
  const regenerateMessageOfConversation = () => {
    regenerateMessage(currentConversation.id);
  };
  // should only happen when no apiConfig is present
  const actionTypeId = (_currentConversation$ = (_currentConversation$2 = currentConversation.apiConfig) === null || _currentConversation$2 === void 0 ? void 0 : _currentConversation$2.actionTypeId) !== null && _currentConversation$ !== void 0 ? _currentConversation$ : '';
  const extraLoadingComment = isFetchingResponse ? [{
    username: i18n.ASSISTANT,
    timelineAvatar: /*#__PURE__*/_react.default.createElement(SpinnerWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    })),
    timestamp: '...',
    children: /*#__PURE__*/_react.default.createElement(_stream.StreamComment, {
      abortStream: abortStream,
      actionTypeId: actionTypeId,
      content: "",
      refetchCurrentConversation: refetchCurrentConversation,
      regenerateMessage: regenerateMessageOfConversation,
      isEnabledLangChain: isEnabledLangChain,
      setIsStreaming: setIsStreaming,
      transformMessage: () => ({
        content: ''
      }),
      isFetching: true
      // we never need to append to a code block in the loading comment, which is what this index is used for
      ,
      index: 999
    })
  }] : [];
  const UserAvatar = () => {
    if (currentUserAvatar) {
      var _currentUserAvatar$co;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, (0, _extends2.default)({
        name: "user",
        size: "l",
        color: (_currentUserAvatar$co = currentUserAvatar === null || currentUserAvatar === void 0 ? void 0 : currentUserAvatar.color) !== null && _currentUserAvatar$co !== void 0 ? _currentUserAvatar$co : 'subdued'
      }, currentUserAvatar !== null && currentUserAvatar !== void 0 && currentUserAvatar.imageUrl ? {
        imageUrl: currentUserAvatar.imageUrl
      } : {
        initials: currentUserAvatar === null || currentUserAvatar === void 0 ? void 0 : currentUserAvatar.initials
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      name: "user",
      size: "l",
      color: "subdued",
      iconType: "userAvatar"
    });
  };
  return [...currentConversation.messages.map((message, index) => {
    var _message$content;
    const isLastComment = index === currentConversation.messages.length - 1;
    const isUser = message.role === 'user';
    const replacements = currentConversation.replacements;
    const messageProps = {
      timelineAvatar: isUser ? /*#__PURE__*/_react.default.createElement(UserAvatar, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        name: "machine",
        size: "l",
        color: "subdued",
        iconType: _elasticAssistant.AssistantAvatar
      }),
      timestamp: i18n.AT(message.timestamp.length === 0 ? new Date().toLocaleString() : new Date(message.timestamp).toLocaleString()),
      username: isUser ? i18n.YOU : i18n.ASSISTANT,
      eventColor: message.isError ? 'danger' : undefined
    };
    const isControlsEnabled = isLastComment && !isUser;
    const transformMessage = content => transformMessageWithReplacements({
      message,
      content,
      showAnonymizedValues,
      replacements
    });

    // message still needs to stream, no actions returned and replacements handled by streamer
    if (!(message.content && message.content.length)) {
      return {
        ...messageProps,
        children: /*#__PURE__*/_react.default.createElement(_stream.StreamComment, {
          abortStream: abortStream,
          actionTypeId: actionTypeId,
          index: index,
          isControlsEnabled: isControlsEnabled,
          isEnabledLangChain: isEnabledLangChain,
          isError: message.isError,
          reader: message.reader,
          refetchCurrentConversation: refetchCurrentConversation,
          regenerateMessage: regenerateMessageOfConversation,
          setIsStreaming: setIsStreaming,
          transformMessage: transformMessage
        })
      };
    }

    // transform message here so we can send correct message to CommentActions
    const transformedMessage = transformMessage((_message$content = message.content) !== null && _message$content !== void 0 ? _message$content : '');
    return {
      ...messageProps,
      actions: /*#__PURE__*/_react.default.createElement(_comment_actions.CommentActions, {
        message: transformedMessage,
        isFlyoutMode: isFlyoutMode
      }),
      children: /*#__PURE__*/_react.default.createElement(_stream.StreamComment, {
        actionTypeId: actionTypeId,
        abortStream: abortStream,
        content: transformedMessage.content,
        index: index,
        isControlsEnabled: isControlsEnabled,
        isEnabledLangChain: isEnabledLangChain
        // reader is used to determine if streaming controls are shown
        ,
        reader: transformedMessage.reader,
        regenerateMessage: regenerateMessageOfConversation,
        refetchCurrentConversation: refetchCurrentConversation,
        setIsStreaming: setIsStreaming,
        transformMessage: transformMessage
      })
    };
  }), ...extraLoadingComment];
};
exports.getComments = getComments;